/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jstl.tagsupport.converter.operations;

import oracle.eclipse.tools.webtier.jstl.tagsupport.converter.operations.AbstractJSTLTransformOperation;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.dtmanager.DTManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractJSTLCheckTableTransformOperation
extends AbstractJSTLTransformOperation {
    protected static final String SPAN_STYLE_FOR_LABEL = "border:0; padding: 0; margin: 0; color:#999999; font-family:sans-serif; font-size:10pt; vertical-align:middle; white-space:nowrap;";
    protected static final String IMG_STYLE_FOR_LABEL = "border:0; padding: 0; margin:0px 3px 0px 0px; vertical-align:middle;";
    private static final int NO_ELEMENT = 0;
    private static final int TABLE_ELEMENT = 1;
    private static final int TABLE_ROW_ELEMENT = 2;

    public Element transform(Element srcElem, Element curElem) {
        if (this.isPreviewMode()) {
            return this.transformForPreview(srcElem, curElem);
        }
        return this.transformForDesigner(srcElem, curElem);
    }

    protected Element transformForPreview(Element srcElem, Element curElem) {
        Element divEle = this.createElement("div");
        String style = "border:none; padding: 0; margin: 0";
        divEle.setAttribute("style", style);
        this.copyChildren(srcElem, divEle);
        return divEle;
    }

    public Element transformForDesigner(Element srcElem, Element curElem) {
        Node containingElement = AbstractJSTLCheckTableTransformOperation.findConvertedParentElement(srcElem, null);
        String name = null;
        if (containingElement != null) {
            name = containingElement.getNodeName();
        }
        if (name != null) {
            if ("table".equalsIgnoreCase(name) || "tbody".equalsIgnoreCase(name) || "tfoot".equalsIgnoreCase(name)) {
                return this.renderAsTableRow(srcElem, false, 1);
            }
            if ("thead".equalsIgnoreCase(name)) {
                return this.renderAsTableRow(srcElem, true, 1);
            }
            if ("tr".equalsIgnoreCase(name)) {
                return this.renderAsTableCell(srcElem, false, 2);
            }
        }
        return this.renderDefault(srcElem, 0);
    }

    protected abstract Element renderDefault(Element var1, int var2);

    private Element renderAsTableRow(Element srcElement, boolean isHeader, int tableElement) {
        Element trElem = this.createElement("tr");
        Element tdElem = this.renderAsTableCell(srcElement, isHeader, tableElement);
        trElem.appendChild(tdElem);
        return trElem;
    }

    private Element renderAsTableCell(Element srcElement, boolean isHeader, int tableElement) {
        Element tdElem = null;
        tdElem = isHeader ? this.createElement("th") : this.createElement("td");
        tdElem.appendChild(this.renderDefault(srcElement, tableElement));
        return tdElem;
    }

    protected void createElementAndCopyChildren(Element srcElem, Element curElem, int tableElement) {
        Element elem = null;
        switch (tableElement) {
            case 1: {
                elem = this.createElement("table");
                elem.setAttribute("border", "0");
                elem.setAttribute("cellspacing", "0");
                elem.setAttribute("cellpadding", "0");
                elem.setAttribute("style", "border:none; border-spacing:0; margin: 0; padding: 0");
                this.copyChildren(srcElem, elem);
                break;
            }
            case 2: {
                elem = this.createElement("table");
                elem.setAttribute("border", "0");
                elem.setAttribute("cellspacing", "0");
                elem.setAttribute("cellpadding", "0");
                Element trElem = this.createElement("tr");
                elem.appendChild(trElem);
                this.copyChildren(srcElem, trElem);
                break;
            }
            default: {
                elem = this.createElement("div");
                elem.setAttribute("style", "border:0; margin: 0; padding: 0");
                this.copyChildren(srcElem, elem);
            }
        }
        curElem.appendChild(elem);
    }

    protected static Node findConvertedParentElement(Element srcElem, Element childElem) {
        Node parent = srcElem.getParentNode();
        if (parent == null || !(parent instanceof Element)) {
            return null;
        }
        String name = parent.getNodeName();
        if ("html".equalsIgnoreCase(name) || "body".equalsIgnoreCase(name)) {
            return null;
        }
        ITagConverter converter = AbstractJSTLCheckTableTransformOperation.createTagConverter((Element)parent);
        if (!converter.isVisualByHTML()) {
            return null;
        }
        converter.convertRefresh(null);
        ConvertPosition position = null;
        if (childElem != null) {
            position = converter.getChildVisualPosition((Node)childElem);
        }
        if (position == null) {
            position = converter.getChildVisualPosition((Node)srcElem);
        }
        if (position != null) {
            return position.getParentNode();
        }
        return AbstractJSTLCheckTableTransformOperation.findConvertedParentElement((Element)parent, srcElem);
    }

    private static ITagConverter createTagConverter(Element elem) {
        return DTManager.getInstance().getTagConverter(elem, 0, null);
    }
}

