/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jstl.locale;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.common.services.webapp.JavaLocalizer;
import oracle.eclipse.tools.webtier.javawebapp.config.WebAppConfigurator;
import org.eclipse.core.resources.IProject;

public class JstlLocalizer
extends JavaLocalizer {
    private static final String JAVAX_SERVLET_JSP_JSTL_FMT_LOCALIZATION_CONTEXT = "javax.servlet.jsp.jstl.fmt.localizationContext";
    private static final String JAVAX_SERVLET_JSP_JSTL_FMT_LOCALE = "javax.servlet.jsp.jstl.fmt.locale";
    private static final String JAVAX_SERVLET_JSP_JSTL_FMT_FALLBACKLOCALE = "javax.servlet.jsp.jstl.fmt.fallbackLocale";

    public JstlLocalizer(Project project) {
        super(project);
    }

    public String getDefaultBaseName() {
        WebAppConfigurator config = WebAppConfigurator.getConfigurator((IProject)this._project);
        return config == null ? null : config.getContextParam(JAVAX_SERVLET_JSP_JSTL_FMT_LOCALIZATION_CONTEXT);
    }

    public Collection<String> getBaseNames() {
        String defaultBaseName = this.getDefaultBaseName();
        List<String> baseNames = defaultBaseName != null ? Collections.singletonList(defaultBaseName) : Collections.emptyList();
        return baseNames;
    }

    public Locale resolveLocale(List<Locale> preferredLocales) {
        WebAppConfigurator config = WebAppConfigurator.getConfigurator((IProject)this._project);
        Locale localeByConfig = this.findLocaleByConfig(config, JAVAX_SERVLET_JSP_JSTL_FMT_LOCALE);
        if (localeByConfig != null) {
            return localeByConfig;
        }
        if (!preferredLocales.isEmpty()) {
            return preferredLocales.get(0);
        }
        Locale fallbackLocale = this.findLocaleByConfig(config, JAVAX_SERVLET_JSP_JSTL_FMT_FALLBACKLOCALE);
        if (fallbackLocale != null) {
            return fallbackLocale;
        }
        return Locale.getDefault();
    }

    private Locale findLocaleByConfig(WebAppConfigurator config, String key) {
        Locale applicationLocale;
        String localeSetting = config.getContextParam(key);
        if (localeSetting != null && (applicationLocale = JstlLocalizer.parse((String)localeSetting)) != null) {
            return applicationLocale;
        }
        return null;
    }
}

