/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jstl.locale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.collection.AbstractLocalizationDiscoveryParticipant;
import oracle.eclipse.tools.application.common.services.documentservices.LocalizationRangeStore;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.webtier.jstl.TraceOptions;
import oracle.eclipse.tools.webtier.jstl.tagsupport.TLDConstants;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;

public final class JstlFmtLocalizationDiscoveryParticipant
extends AbstractLocalizationDiscoveryParticipant {
    private static final String ID = JstlFmtLocalizationDiscoveryParticipant.class.getName();
    private static final List<String> FORMAT_URIS;
    private static final boolean DEBUG;

    static {
        DEBUG = TraceOptions.JSTL_LOCALIZATION_DISCOVERY;
        ArrayList<String> uris = new ArrayList<String>();
        uris.add(TLDConstants.TAGLIB.FORMAT.getUri());
        uris.add(TLDConstants.TAGLIB.FORMAT_v10.getUri());
        FORMAT_URIS = Collections.unmodifiableList(uris);
    }

    public JstlFmtLocalizationDiscoveryParticipant() {
        this(new AbstractLocalizationDiscoveryParticipant.LocalizationInjectableDependencies("jstl", DEBUG));
    }

    public JstlFmtLocalizationDiscoveryParticipant(AbstractLocalizationDiscoveryParticipant.LocalizationInjectableDependencies dependencies) {
        super(ID, dependencies);
    }

    protected AbstractLocalizationDiscoveryParticipant.LocalizationVisitor createVisitor() {
        return new Visitor(this.getDependencies());
    }

    protected AbstractLocalizationDiscoveryParticipant.LocalizationVisitor doDiscover(IVisitableDOMModel model) {
        Integer localCounter = counter++;
        if (this.getDependencies().isDebugEnabled()) {
            System.out.printf("JSTL Localization: begin discovery (%d)\n", localCounter);
        }
        AbstractLocalizationDiscoveryParticipant.LocalizationVisitor visitor = super.doDiscover(model);
        if (this.getDependencies().isDebugEnabled()) {
            System.out.printf("JSTL Localization: end discovery (%d)\n", localCounter);
        }
        return visitor;
    }

    private static class Visitor
    extends AbstractLocalizationDiscoveryParticipant.LocalizationVisitor {
        public Visitor(AbstractLocalizationDiscoveryParticipant.LocalizationInjectableDependencies dependencies) {
            super(dependencies);
        }

        public boolean visit(IDOMElement element) {
            LocalizationRangeStore bundles = this.getDependencies().getBundles();
            if (this.isFormatTag((Node)element, "message")) {
                if (this.getDependencies().getDomUtil().getAttributeValue((Node)element, "bundle") != null) {
                    this.addBundleRange(this._rangeFactory.createRange(element), this._rangeFactory.createRangeForAttributeValue((IDOMAttr)element.getAttributeNode("bundle")), (String)bundles.getOverrideValue());
                    return false;
                }
            } else if (this.isFormatTag((Node)element, "bundle")) {
                String value = this.getDependencies().getDomUtil().getAttributeValue((Node)element, "basename");
                if (value != null && (value = value.trim()).length() > 0) {
                    this.addBundleRange(this._rangeFactory.createRange(element), this._rangeFactory.createRangeForAttributeValue((IDOMAttr)element.getAttributeNode("basename")), value);
                }
            } else if (this.isFormatTag((Node)element, "setBundle")) {
                String bundleValue = this.getDependencies().getDomUtil().getAttributeValue((Node)element, "basename");
                String varValue = this.getDependencies().getDomUtil().getAttributeValue((Node)element, "var");
                if (bundleValue != null) {
                    if ((bundleValue = bundleValue.trim()).length() > 0 && varValue == null) {
                        this.addBundleRange(this._rangeFactory.createRangeToEndOfDoc(element), this._rangeFactory.createRangeForAttributeValue((IDOMAttr)element.getAttributeNode("basename")), bundleValue);
                    } else if (bundleValue.length() > 0 && varValue != null) {
                        this.addBundleRange(new Range(0L, 0L), this._rangeFactory.createRangeForAttributeValue((IDOMAttr)element.getAttributeNode("basename")), bundleValue);
                    }
                }
            }
            return true;
        }

        private boolean isFormatTag(Node node, String name) {
            return this.getDependencies().getDomUtil().isNode(this.getDependencies().getDocument(), node, FORMAT_URIS, name);
        }
    }
}

