/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedMap<K, V>
extends HashMap<K, V> {
    protected List<NameValuePair<K, V>> list;

    public OrderedMap() {
        this.list = new ArrayList<NameValuePair<K, V>>();
    }

    public OrderedMap(List<NameValuePair<K, V>> list) {
        this.list = list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public V get(Object key) {
        V obj = null;
        for (int i = 0; i < this.list.size(); ++i) {
            if (!key.equals(this.list.get(i).getName())) continue;
            obj = this.list.get(i).getValue();
            break;
        }
        return obj;
    }

    public V put(K key, V value, boolean duplicatesAllowed) {
        V obj = null;
        if (!duplicatesAllowed && this.containsKey(key)) {
            obj = this.remove(key);
        }
        this.list.add(new NameValuePair<K, V>(key, value));
        return obj;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, false);
    }

    @Override
    public V remove(Object key) {
        V obj = null;
        for (int i = 0; i < this.list.size(); ++i) {
            if (!key.equals(this.list.get(i).getName())) continue;
            obj = this.list.get(i).getValue();
            this.list.remove(i);
            break;
        }
        return obj;
    }

    @Override
    public void putAll(Map t) {
        if (t == null) {
            return;
        }
        Set set = t.entrySet();
        for (Map.Entry e : set) {
            Object key = e.getKey();
            Object value = e.getValue();
            this.list.add(new NameValuePair(key, value));
        }
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Set<K> keySet() {
        LinkedHashSet<K> set = new LinkedHashSet<K>();
        for (int i = 0; i < this.list.size(); ++i) {
            set.add(this.list.get(i).getName());
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> col = new ArrayList<V>();
        for (int i = 0; i < this.list.size(); ++i) {
            col.add(this.list.get(i).getValue());
        }
        return col;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("Not implemented");
    }

    public void setList(List<NameValuePair<K, V>> list) {
        this.list = list;
    }

    public List<NameValuePair<K, V>> getList() {
        return this.list;
    }

    public OrderedMap simpleClone() {
        OrderedMap<K, V> map = new OrderedMap<K, V>();
        map.setList((ArrayList)((ArrayList)this.getList()).clone());
        return map;
    }
}

