/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.nls;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class NLSUtil {
    private static final List<ResourceBundle> nlsBundles = new ArrayList<ResourceBundle>();

    public static synchronized void addBundle(String baseName, ClassLoader loader) {
        NLSUtil.addBundle(ResourceBundle.getBundle(baseName, Locale.getDefault(), loader));
    }

    public static synchronized void addBundle(ResourceBundle bundle) {
        if (bundle != null && !nlsBundles.contains(bundle)) {
            nlsBundles.add(0, bundle);
        }
    }

    public static String localizeMessage(String id) {
        return NLSUtil.localizeMessage(id, null);
    }

    public static String localizeMessageOrReturnId(String id) {
        return NLSUtil.localizeMessage(id, null, true);
    }

    public static String localizeMessage(String id, Object obj) {
        return NLSUtil.localizeMessage(id, new Object[]{obj});
    }

    public static String localizeMessage(String id, Object obj, Object obj1) {
        return NLSUtil.localizeMessage(id, new Object[]{obj, obj1});
    }

    public static String localizeMessage(String id, Object[] dynamic) {
        return NLSUtil.localizeMessage(id, dynamic, false);
    }

    public static String localizeMessage(String id, Object[] dynamic, boolean returnid) {
        String val = null;
        if (id == null || id.trim().equals("")) {
            return "";
        }
        for (ResourceBundle bundle : nlsBundles) {
            try {
                val = bundle.getString(id);
            }
            catch (MissingResourceException m) {
                continue;
            }
            if (val == null) continue;
            break;
        }
        if (val == null) {
            if (returnid) {
                return id;
            }
            return "[Localization failed] " + id + ".";
        }
        if (dynamic != null) {
            for (int i = 0; i < dynamic.length; ++i) {
                if (dynamic[i] != null) continue;
                dynamic[i] = "";
            }
        }
        if (dynamic == null) {
            return val;
        }
        return MessageFormat.format(val, dynamic);
    }

    static {
        NLSUtil.addBundle("com.oracle.cloudlogic.javaservice.common.clibase.LogMessages", NLSUtil.class.getClassLoader());
    }
}

