/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.display;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.cloudlogic.javaservice.common.clibase.display.Cell;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Row {
    private List<Cell> cells = null;

    public Row(int colCount) {
        this.cells = new ArrayList<Cell>(Arrays.asList(new Cell[colCount]));
        for (int i = 0; i < this.cells.size(); ++i) {
            this.cells.set(i, new Cell());
        }
    }

    public void setGridAt(Grid grid, int col) {
        Cell c = this.cells.get(col);
        if (c == null) {
            c = new Cell();
            this.cells.set(col, c);
        }
        c.setInnderGrid(grid);
        c.setCenterAlign(true);
    }

    public void setContents(List<String> contents, int col) {
        Cell c = this.cells.get(col);
        if (c == null) {
            c = new Cell();
            this.cells.set(col, c);
        }
        c.setContents(contents);
    }

    public void setValueAt(String val, int col) {
        this.setValueAt(val, col, false);
    }

    public void setValueAt(String val, int col, boolean center) {
        Cell c = this.cells.get(col);
        if (c == null) {
            c = new Cell();
            this.cells.set(col, c);
        }
        c.setContent(val);
        c.setCenterAlign(center);
    }

    public void setObjectAt(Object val, int col) {
        this.setObjectAt(val, col, false);
    }

    public void setObjectAt(Object val, int col, boolean center) {
        if (val == null) {
            this.setValueAt(null, col);
        } else if (Grid.class.isAssignableFrom(val.getClass())) {
            this.setGridAt((Grid)val, col);
        } else if (List.class.isAssignableFrom(val.getClass())) {
            this.setContents((List)val, col);
        } else {
            this.setValueAt(val.toString(), col, center);
        }
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public int getMaxLines() {
        int lines = 0;
        for (Cell c : this.cells) {
            if (c.getLinesCount() <= lines) continue;
            lines = c.getLinesCount();
        }
        return lines;
    }

    public void verticalAlign() {
        int maxlines = this.getMaxLines();
        for (Cell c : this.cells) {
            c.verticalAlign(maxlines);
        }
    }
}

