/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.util;

import java.util.ArrayList;
import oracle.cloud.paas.client.ClientConstants;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.MainBase;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.display.Row;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliExitCodeException;
import oracle.cloudlogic.javaservice.common.clibase.executor.CliExecutor;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.utils.CommonUtils;

public class ListCommands
implements CliExecutor,
ClientConstants {
    protected boolean grid = false;
    protected int gridWidth = 180;
    protected boolean descending = false;
    protected String sorton = null;
    protected boolean full = false;
    protected String grep = null;
    private MainBase main = null;
    private CommandLine command;

    public ListCommands(MainBase main) {
        this.main = main;
    }

    @Override
    public void setCommandLine(CommandLine commandLine) {
        this.command = commandLine;
    }

    @Override
    public void validate() throws CliException {
        try {
            String gw;
            this.grep = this.command.getArgValue("search", "");
            this.grid = this.command.getValueAsBoolean("grid");
            this.descending = this.command.getValueAsBoolean("descending");
            this.sorton = this.command.getArgValue("sorton");
            if ((this.sorton == null || this.sorton.trim().equals("")) && this.descending) {
                Logger.getDEFAULT().printlnWarning("descending is not applicable when sorton is not specified.");
            }
            if ((gw = this.command.getArgValue("gridwidth")) != null) {
                try {
                    this.gridWidth = Integer.parseInt(gw);
                    if (this.gridWidth < 0) {
                        throw new NumberFormatException("gridwidth must be a positive integer");
                    }
                }
                catch (NumberFormatException e) {
                    throw new CliException("Please enter valid value for gridwidth", e);
                }
            }
            this.full = this.command.getValueAsBoolean("verbose");
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    @Override
    public void execute() throws Exception {
        ArrayList<CommandLine> list = new ArrayList<CommandLine>();
        MainBase base = this.main;
        OrderedMap<String, CommandLine> map = base.getAllCommands();
        for (NameValuePair<String, CommandLine> pair : map.getList()) {
            CommandLine cmd = pair.getValue();
            if (!cmd.getCommandName().contains(this.grep) && !cmd.getDescription().contains(this.grep)) continue;
            list.add(cmd);
        }
        if (list.isEmpty()) {
            throw new CliExitCodeException(100, "No commands found.", null);
        }
        int allignLength = CloudUtil.getKeyMaxLengthProcessEachCommand(map);
        if (this.grid) {
            Grid g = new Grid();
            g.addColumn("##");
            g.addColumn("Command Name");
            if (this.full) {
                g.addColumn("Mandatory Arguments");
                g.addColumn("Command Description");
            }
            g.getColumns().get("Command Name").setWidth(allignLength);
            int count = 0;
            for (CommandLine c : list) {
                int col = 0;
                Row r = g.createNewRow();
                r.setObjectAt(String.valueOf(++count), col++);
                r.setObjectAt(c.getCommandName(), col++);
                if (!this.full) continue;
                ArrayList<String> margs = new ArrayList<String>();
                for (CommandLineArg a : c.getArgument()) {
                    if (!a.isMandatory()) continue;
                    margs.add(a.getOptionName());
                }
                r.setObjectAt(CommonUtils.getCommaSeparatedListOfString(margs, (String)"", (String)"", (boolean)false), col++);
                r.setObjectAt(c.getDescription(), col++);
            }
            BeanUtils.printGridRecursive(g, "commands matching \"" + this.grep + "\"", this.gridWidth, true);
        } else {
            for (CommandLine c : list) {
                if (this.full) {
                    Logger.getDEFAULT().println(CloudUtil.convertToHelpText(CloudUtil.padChar(allignLength, ' ', c.getCommandName().trim(), allignLength, true) + " - " + c.getDescription(), this.gridWidth, allignLength + 3));
                    continue;
                }
                Logger.getDEFAULT().println(c.getCommandName());
            }
        }
    }
}

