/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.service;

import oracle.cloud.paas.client.cli.command.common.wlst.WLSTShell;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.service.AbstractServiceCommand;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.types.CommandType;
import oracle.cloudlogic.javaservice.utils.CommonUtils;

public class SetServiceConfiguration
extends AbstractServiceCommand {
    public SetServiceConfiguration(WLSTShell wlst) {
        super(wlst);
    }

    @Override
    public void validate() throws CliException {
        super.validate();
        String configs = this.command.getArgValue("configprops");
        CommonUtils.setArg((CommandType)this.cmd, (String)"itemProperties", (String)SetServiceConfiguration.propertiesToWLSTArg(configs));
    }

    public static String propertiesToWLSTArg(String configs) throws CliException {
        OrderedMap<String, String> commandlineProperties = CloudUtil.parseCommandlineProperties(configs, null);
        if (commandlineProperties.isEmpty()) {
            throw new CliException("No config provided. Please specify configprops");
        }
        StringBuffer buffer = new StringBuffer("[(");
        boolean first = true;
        for (NameValuePair<String, String> pair : commandlineProperties.getList()) {
            if (pair.getName() == null || "".equals(pair.getName().trim())) continue;
            if (!first) {
                buffer.append("),(");
            }
            String key = pair.getName();
            String val = pair.getValue();
            if (!key.startsWith("\"") && !key.endsWith("\"")) {
                key = "\"" + key + "\"";
            }
            if (!val.startsWith("\"") && !val.endsWith("\"")) {
                val = "\"" + val + "\"";
            }
            buffer.append(key + "," + val);
            first = false;
        }
        buffer.append(")]");
        return buffer.toString();
    }
}

