/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.wlst;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.cloud.paas.client.cli.command.common.CommonBaseExecutor;
import oracle.cloud.paas.client.cli.command.common.wlst.WLSTMain;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.exception.UnknownResourceException;
import oracle.cloudlogic.javaservice.common.api.service.ResourceManagerService;
import oracle.cloudlogic.javaservice.common.api.service.Service;
import oracle.cloudlogic.javaservice.common.api.service.resource.wlst.WLSTAccessShellService;
import oracle.cloudlogic.javaservice.common.clibase.MainBase;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliExitCodeException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.StringUtils;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.CommandType;

public class WLSTShell
extends CommonBaseExecutor {
    protected String commandstr = null;
    protected WLSTAccessShellService wlst = null;
    protected boolean exitonfailure = false;
    ServiceManager serviceManager = null;
    boolean exit = false;
    boolean retainonexit = false;
    List<String> commands = new ArrayList<String>();
    WLSTMain main = null;

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public Properties getRuntimeProperties() {
        return MainBase.getMain().getDefaultProperties(this.command);
    }

    public WLSTAccessShellService getWLST() {
        return this.wlst;
    }

    public WLSTMain getMain() {
        return this.main;
    }

    @Override
    public void validate() throws CliException {
        super.validate();
        try {
            this.exitonfailure = this.command.getValueAsBoolean("autoexitonfailure");
            this.commandstr = this.command.getArgValue("command");
            if (this.commandstr == null && this.exitonfailure) {
                Logger.getDEFAULT().printlnWarning("Ignoring:autoexitonfailure");
                this.exitonfailure = false;
            }
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    @Override
    public void invoke(ServiceManager client) throws Exception {
        this.serviceManager = client;
        ResourceManagerService res = (ResourceManagerService)client.getService(ResourceManagerService.class);
        this.wlst = (WLSTAccessShellService)res.getResourceService(WLSTAccessShellService.class);
        this.main = WLSTMain.createWith(this);
        this.main.MAX_COLUMN_LENGTH = 120;
        this.shellWith(this.commandstr);
    }

    public Class<? extends Service> getServiceClass() {
        return WLSTAccessShellService.class;
    }

    public void shellWith(String line) throws Exception {
        if (line == null) {
            Logger.getDEFAULT().println("Java service config  shell.");
            Logger.getDEFAULT().println("Initializing ...");
            line = "";
        }
        if (this.wlst.initWLSTSession((OutputStream)System.out)) {
            this.wlst.goOnlineWLST();
        } else {
            Logger.getDEFAULT().printlnInfo("Session already exists.");
        }
        int lastStatus = 0;
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        boolean usercommand = false;
        while (true) {
            try {
                List<String> cmds = StringUtils.parseWithQuote(line, ";");
                if (cmds.isEmpty() && usercommand) {
                    this.wlst.executeWLSTCommand(new CommandType());
                }
                for (String l : cmds) {
                    if (l.startsWith("!") && !this.commands.isEmpty()) {
                        l = this.commands.get(this.commands.size() - 1) + l.substring(1, l.length());
                    }
                    if (!this.commands.contains(l)) {
                        this.commands.add(l);
                    }
                    Logger.getDEFAULT().printlnDebug("Executing:" + l);
                    lastStatus = this.main.doCommand(StringUtils.parseWithQuote(l, " ").toArray(new String[0]));
                    if (lastStatus != 0) {
                        this.wlst.executeWLSTCommand(new CommandType());
                    }
                    if (lastStatus == 0 || !this.exitonfailure) continue;
                    this.exit = true;
                    break;
                }
            }
            catch (UnknownResourceException un) {
                Logger.getDEFAULT().printlnError(un.getMessage());
                Logger.getDEFAULT().println("Please type exit to exit the session.");
                Logger.getDEFAULT().printlnThrowable(un);
            }
            catch (Exception e) {
                Logger.getDEFAULT().printlnError(e.getMessage());
                Logger.getDEFAULT().printlnThrowable(e);
                lastStatus = 4;
            }
            if (this.exit) break;
            Logger.getDEFAULT().flush();
            line = br.readLine();
            if (line == null) {
                line = "";
            }
            line = line.trim();
            usercommand = true;
        }
        if (!this.retainonexit) {
            this.wlst.goOffLineWLST();
            this.wlst.endWLSTSession();
        }
        if (lastStatus != 0) {
            throw new CliExitCodeException(lastStatus, "Last command has failed before the shell exited.", null);
        }
    }
}

