/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.wlst;

import java.util.List;
import oracle.cloud.paas.client.cli.command.common.wlst.WLSTShell;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.AbstractWLSTCommand;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.StringUtils;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.CommandType;

public class History
extends AbstractWLSTCommand {
    String dump = null;

    public History(WLSTShell fs) {
        super(fs);
    }

    @Override
    public void validate() throws CliException {
        super.validate();
    }

    public void dumpIfEnabled() throws Exception {
        this.dump = this.command.getArgValue("dump");
        if (this.dump != null) {
            StringBuffer buffer = new StringBuffer();
            OrderedMap<Integer, Integer> range = new OrderedMap<Integer, Integer>();
            List<String> list = StringUtils.parseWithQuote(this.dump, ",");
            for (String string : list) {
                String string2 = string.trim();
                if (string2.equals("")) continue;
                int index = string2.indexOf("-");
                if (index < 0) {
                    range.put(Integer.parseInt(string2), Integer.parseInt(string2));
                    continue;
                }
                String left = string2.substring(0, index).trim();
                String right = string2.substring(index + 1, string2.length()).trim();
                if (left.equals("")) {
                    left = "0";
                }
                if (right.equals("")) {
                    right = String.valueOf(this.shell.commands.size() - 1);
                }
                range.put(Integer.parseInt(left), Integer.parseInt(right));
            }
            if (range.isEmpty() && !this.shell.commands.isEmpty()) {
                range.put(0, this.shell.commands.size() - 1);
            }
            for (NameValuePair nameValuePair : range.getList()) {
                int right;
                int left = (Integer)nameValuePair.getName();
                if (left > (right = ((Integer)nameValuePair.getValue()).intValue())) {
                    left = (Integer)nameValuePair.getValue();
                    right = (Integer)nameValuePair.getName();
                }
                while (left <= right) {
                    if (left >= 0 && left < this.shell.commands.size()) {
                        buffer.append(this.shell.commands.get(left));
                        buffer.append(";");
                    }
                    ++left;
                }
            }
            Logger.getDEFAULT().printlnInfo("----Dump Starts----");
            System.out.println(buffer.toString());
            Logger.getDEFAULT().printlnInfo("----Dump Ends----");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        this.shell.commands.remove(this.shell.commands.size() - 1);
        if (!this.shell.commands.isEmpty()) {
            this.dumpIfEnabled();
        }
        if (this.command.getExtraArgs().isEmpty()) {
            Logger logger = Logger.getDEFAULT();
            synchronized (logger) {
                if (this.shell.commands.isEmpty()) {
                    Logger.getDEFAULT().printlnInfo("No history found.");
                } else {
                    Logger.getDEFAULT().initMapText();
                    Logger.getDEFAULT().addMapText("---", "----------------------------------------");
                    Logger.getDEFAULT().addMapText("id", "command");
                    Logger.getDEFAULT().addMapText("---", "----------------------------------------");
                    int count = 1;
                    for (String c : this.shell.commands) {
                        Logger.getDEFAULT().addMapText(String.valueOf(count++), c);
                    }
                    Logger.getDEFAULT().addMapText("---", "----------------------------------------");
                    Logger.getDEFAULT().endMapText(120);
                }
            }
            this.shell.getWLST().executeWLSTCommand(new CommandType());
        } else {
            for (String line : this.command.getExtraArgs()) {
                int ret = Integer.parseInt(line) - 1;
                if (ret >= this.shell.commands.size()) {
                    throw new Exception("No command found in the history.");
                }
                line = this.shell.commands.get(ret);
                if (this.shell.main.doCommand(StringUtils.parseWithQuote(line, " ").toArray(new String[0])) == 0) continue;
                this.shell.getWLST().executeWLSTCommand(new CommandType());
            }
        }
    }
}

