/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.ssl.trust;

import java.util.Collections;
import java.util.List;
import oracle.cloud.paas.client.cli.bean.CertificateComparator;
import oracle.cloud.paas.client.cli.command.common.CommonBeanUtil;
import oracle.cloud.paas.client.cli.command.common.ListingCommonBaseExecutor;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.service.ResourceManagerService;
import oracle.cloudlogic.javaservice.common.api.service.Service;
import oracle.cloudlogic.javaservice.common.api.service.resource.CertificateService;
import oracle.cloudlogic.javaservice.common.api.service.resource.SSLService;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class ListCertificates
extends ListingCommonBaseExecutor {
    CertificateComparator.FIELD sortField = null;

    @Override
    public void validate() throws CliException {
        block4: {
            super.validate();
            try {
                if (this.sorton == null || this.sorton.trim().equals("")) break block4;
                try {
                    this.sortField = CertificateComparator.FIELD.valueOf(this.sorton.toUpperCase());
                }
                catch (Exception e) {
                    throw new Exception(NLSUtil.localizeMessage("NLS_OPTION_VALUE_INVALID_FOR_POSSIBLE_VALUES", new Object[]{"sorton", this.sorton, CloudUtil.getCommaSeparatedListOfString(CloudUtil.getEnumValuesAsList(CertificateComparator.FIELD.class))}));
                }
            }
            catch (Exception e) {
                throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
            }
        }
    }

    @Override
    public void invoke(ServiceManager client) throws Exception {
        ResourceManagerService res = (ResourceManagerService)client.getService(ResourceManagerService.class);
        CertificateService c = ((SSLService)res.getResourceService(SSLService.class)).getSSLTrustService();
        List list = c.listCertificates();
        if (list.isEmpty()) {
            Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_NO_CERT_FOUND");
        } else {
            if (this.sortField != null) {
                Collections.sort(list, new CertificateComparator(this.sortField, this.descending));
            }
            CommonBeanUtil.printCertificates(list, this.verbose, "\n[Identity Domain=" + this.tenantID + ", Service Instance=" + this.serviceID + "]", this.grid, this.gridWidth, "SSL");
        }
    }

    public Class<? extends Service> getServiceClass() {
        return CertificateService.class;
    }
}

