/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.fs.cmd;

import java.io.File;
import java.io.InputStream;
import oracle.cloud.paas.client.cli.command.common.fs.FSBaseCommandExecutor;
import oracle.cloud.paas.client.cli.command.common.fs.FSShell;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;

public class Put
extends FSBaseCommandExecutor {
    boolean force = false;

    public Put(FSShell fs) {
        super(fs);
    }

    @Override
    public void validate() throws CliException {
        super.validate();
        if (this.command.getExtraArgs().isEmpty()) {
            throw new CliException("path must be specified. E.g)" + this.command.getCommandName() + " <local path>");
        }
        this.force = this.command.getValueAsBoolean("force");
    }

    @Override
    public void execute0() throws Exception {
        for (String d : this.command.getExtraArgs()) {
            if (this.exists(new File(d).getName()) && !this.force) {
                throw new Exception("Remote file " + new File(d).getName() + " exists, Please force the operation to overwrite.");
            }
            if (this.isDir(new File(d).getName())) {
                throw new Exception("Remote path " + new File(d).getName() + " is not a file.");
            }
            InputStream in = this.shell.getLocalfs().read(d);
            this.fs.write(new File(d).getName(), in, this.force);
        }
    }
}

