/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import oracle.cloud.paas.client.cli.command.common.CommonBaseExecutor;
import oracle.cloud.paas.client.cli.command.common.fs.FSMain;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.service.ResourceManagerService;
import oracle.cloudlogic.javaservice.common.api.service.Service;
import oracle.cloudlogic.javaservice.common.api.service.resource.fileaccess.FileAccessShellService;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliExitCodeException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.StringUtils;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.common.impl.FileAccessShellServiceImpl;

public class FSShell
extends CommonBaseExecutor {
    protected boolean grid = false;
    protected boolean exitonfailure = false;
    protected boolean validatespecial = true;
    public static final char[] not_allowed_chars = FileAccessShellService.not_allowed_chars;
    protected int gridWidth = 180;
    protected String commandstr = null;
    protected FileAccessShellService fs = null;
    protected FileAccessShellService localfs = null;
    boolean exit = false;
    List<String> commands = new ArrayList<String>();
    FSMain main = null;

    public boolean isGrid() {
        return this.grid;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public FileAccessShellService getLocalfs() {
        return this.localfs;
    }

    public FileAccessShellService getFs() {
        return this.fs;
    }

    private String[] validateCharacters(String[] args) throws Exception {
        if (!this.validatespecial) {
            return args;
        }
        if (args == null) {
            return args;
        }
        for (String a : args) {
            for (int i = 0; i < a.length(); ++i) {
                for (int j = 0; j < not_allowed_chars.length; ++j) {
                    if (not_allowed_chars[j] != a.charAt(i)) continue;
                    Logger.getDEFAULT().printlnTip("You can consider switching off the option 'validatespecialchars' before entering the shell.");
                    throw new Exception("Invalid char '" + not_allowed_chars[j] + "' at \"" + a + "\"");
                }
            }
        }
        return args;
    }

    @Override
    public void validate() throws CliException {
        block6: {
            super.validate();
            try {
                this.grid = this.command.getValueAsBoolean("grid");
                this.exitonfailure = this.command.getValueAsBoolean("autoexitonfailure");
                this.validatespecial = this.command.getValueAsBoolean("validatespecialchars");
                String gw = this.command.getArgValue("gridwidth");
                this.commandstr = this.command.getArgValue("command");
                if (this.commandstr == null && this.exitonfailure) {
                    Logger.getDEFAULT().printlnWarning("Ignoring:autoexitonfailure");
                    this.exitonfailure = false;
                }
                if (gw == null) break block6;
                try {
                    this.gridWidth = Integer.parseInt(gw);
                    if (this.gridWidth < 0) {
                        throw new NumberFormatException("gridwidth must be a positive integer");
                    }
                }
                catch (NumberFormatException e) {
                    throw new CliException("Please enter valid value for gridwidth", e);
                }
            }
            catch (Exception e) {
                throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
            }
        }
    }

    @Override
    public void invoke(ServiceManager client) throws Exception {
        ResourceManagerService res = (ResourceManagerService)client.getService(ResourceManagerService.class);
        this.fs = (FileAccessShellService)res.getResourceService(FileAccessShellService.class);
        this.localfs = new FileAccessShellServiceImpl(new File(".").getCanonicalPath());
        this.main = FSMain.createWith(this);
        this.shellWith(this.commandstr);
    }

    public Class<? extends Service> getServiceClass() {
        return FileAccessShellService.class;
    }

    public void shellWith(String line) throws Exception {
        this.fs.describe(this.fs.pwd());
        int lastStatus = 0;
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        if (line == null) {
            Logger.getDEFAULT().println("Java service file-system access shell.\nThe root directory \"/\" points \"/customer/scratch/\"");
            line = "";
        }
        while (true) {
            try {
                List<String> cmds = StringUtils.parseWithQuote(line, ";");
                for (String l : cmds) {
                    if (l.startsWith("!") && !this.commands.isEmpty()) {
                        l = this.commands.get(this.commands.size() - 1) + l.substring(1, l.length());
                    }
                    if (!this.commands.contains(l)) {
                        this.commands.add(l);
                    }
                    Logger.getDEFAULT().printlnDebug("Executing:" + l);
                    lastStatus = this.main.doCommand(this.validateCharacters(StringUtils.parseWithQuote(l, " ").toArray(new String[0])));
                    if (lastStatus == 0 || !this.exitonfailure) continue;
                    this.exit = true;
                    break;
                }
            }
            catch (Exception e) {
                Logger.getDEFAULT().printlnError(e.getMessage());
                Logger.getDEFAULT().printlnThrowable(e);
                lastStatus = 4;
            }
            if (this.exit) break;
            Logger.getDEFAULT().print(this.fs.pwd() + ">");
            Logger.getDEFAULT().flush();
            line = br.readLine();
            if (line == null) {
                line = "";
            }
            line = line.trim();
        }
        if (lastStatus != 0) {
            throw new CliExitCodeException(lastStatus, "Last command has failed before the shell exited.", null);
        }
    }
}

