/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.fs;

import oracle.cloud.paas.client.ClientConstants;
import oracle.cloud.paas.client.cli.command.common.fs.FSShell;
import oracle.cloudlogic.javaservice.common.api.exception.DuplicateResourceException;
import oracle.cloudlogic.javaservice.common.api.exception.ResourcePermissionException;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.exception.UnknownResourceException;
import oracle.cloudlogic.javaservice.common.api.service.resource.fileaccess.FileAccessShellService;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.executor.CliExecutor;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.FilePathType;
import oracle.cloudlogic.javaservice.types.FolderPathType;

public abstract class FSBaseCommandExecutor
implements CliExecutor,
ClientConstants {
    protected FSShell shell;
    protected FileAccessShellService fs = null;
    protected CommandLine command = null;

    public FSBaseCommandExecutor(FSShell fs) {
        this.shell = fs;
        this.fs = this.shell.getFs();
    }

    @Override
    public void validate() throws CliException {
    }

    private boolean canForceBeTried() {
        return this.canArgBeTried("force");
    }

    private boolean canRecurseBeTried() {
        return this.canArgBeTried("recursive");
    }

    private boolean canArgBeTried(String boolArg) {
        CommandLineArg f = this.command.getArgs().get(boolArg);
        if (f == null) {
            return false;
        }
        return !this.command.getValueAsBoolean(boolArg);
    }

    public abstract void execute0() throws Exception;

    @Override
    public void execute() throws Exception {
        try {
            this.execute0();
        }
        catch (UnknownResourceException un) {
            throw un;
        }
        catch (DuplicateResourceException dup) {
            throw dup;
        }
        catch (ResourcePermissionException per) {
            throw per;
        }
        catch (ServiceException se) {
            if (this.canForceBeTried()) {
                Logger.getDEFAULT().printlnTip("The option -force might help.");
            }
            if (this.canRecurseBeTried()) {
                Logger.getDEFAULT().printlnTip("The option -recursive might help.");
            }
            throw se;
        }
    }

    @Override
    public void setCommandLine(CommandLine command) {
        this.command = command;
    }

    protected boolean exists(String path) throws ServiceException {
        try {
            this.fs.describe(path);
            return true;
        }
        catch (UnknownResourceException un) {
            return false;
        }
    }

    protected boolean existLocal(String path) throws ServiceException {
        try {
            this.shell.getLocalfs().describe(path);
            return true;
        }
        catch (UnknownResourceException un) {
            return false;
        }
    }

    protected boolean isLocalDir(String path) throws ServiceException {
        try {
            return FolderPathType.class.isAssignableFrom(this.shell.getLocalfs().describe(path).getClass());
        }
        catch (UnknownResourceException un) {
            return false;
        }
    }

    protected boolean isLocalFile(String path) throws ServiceException {
        try {
            return FilePathType.class.isAssignableFrom(this.shell.getLocalfs().describe(path).getClass());
        }
        catch (UnknownResourceException un) {
            return false;
        }
    }

    protected boolean isDir(String path) throws ServiceException {
        try {
            return FolderPathType.class.isAssignableFrom(this.fs.describe(path).getClass());
        }
        catch (UnknownResourceException un) {
            return false;
        }
    }

    protected boolean isFile(String path) throws ServiceException {
        try {
            return FilePathType.class.isAssignableFrom(this.fs.describe(path).getClass());
        }
        catch (UnknownResourceException un) {
            return false;
        }
    }
}

