/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.dsjndi;

import java.util.List;
import oracle.cloud.paas.client.cli.command.common.CommonBeanUtil;
import oracle.cloud.paas.client.cli.command.common.ListingCommonBaseExecutor;
import oracle.cloud.paas.model.ServiceType;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.service.ResourceManagerService;
import oracle.cloudlogic.javaservice.common.api.service.Service;
import oracle.cloudlogic.javaservice.common.api.service.resource.DataSourceJndiService;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.types.AssociationType;
import oracle.cloudlogic.javaservice.types.JndiNamesType;
import oracle.cloudlogic.javaservice.types.UserInstanceType;

public class ListDSJndiNames
extends ListingCommonBaseExecutor {
    private String ds;

    @Override
    public void validate() throws CliException {
        super.validate();
        this.ds = this.command.getArgValue("datasource");
    }

    @Override
    public void invoke(ServiceManager client) throws Exception {
        ResourceManagerService r = (ResourceManagerService)client.getService(ResourceManagerService.class);
        if (this.ds == null) {
            UserInstanceType instance = r.describeService();
            for (AssociationType at : instance.getAssociation()) {
                if (!ServiceType.DATABASE.toString().equals(at.getType())) continue;
                this.ds = at.getName();
                break;
            }
            if (this.ds == null) {
                throw new Exception("No data source found;");
            }
        }
        DataSourceJndiService d = (DataSourceJndiService)r.getResourceService(DataSourceJndiService.class);
        JndiNamesType jndiNames = d.listJndiNames(this.ds);
        List list = jndiNames.getJndiname();
        CommonBeanUtil.printDSJndiNames(list, "\n[Identity Domain=" + this.tenantID + "," + " Service Instance=" + this.serviceID + "]", this.grid, this.gridWidth);
    }

    public Class<? extends Service> getServiceClass() {
        return DataSourceJndiService.class;
    }
}

