/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.certficate;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.KeyStore;
import java.util.List;
import oracle.cloud.paas.client.cli.command.common.CommonBaseExecutor;
import oracle.cloud.paas.client.cli.command.common.certficate.CertificateServiceExtension;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.service.Service;
import oracle.cloudlogic.javaservice.common.api.service.resource.CertificateService;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.Certificate;

public class CommonGetCertificates
extends CommonBaseExecutor {
    private List<String> aliases;
    private String output;
    private CERT_TYPE cert_type = null;

    @Override
    public void validate() throws CliException {
        String ext;
        super.validate();
        String alias = this.command.getArgValue("alias");
        if (alias != null) {
            alias = CloudUtil.parseAndRemoveDuplicates(alias, ",");
            this.aliases = CloudUtil.parseString(alias, ",", true);
        }
        this.output = this.command.getArgValue("output", "./");
        String type = this.command.getArgValue("certfiletype");
        if (!new File(this.output).isFile()) {
            try {
                this.output = CloudUtil.validateOutputDir(this.output).getAbsolutePath();
            }
            catch (Exception e) {
                throw new CliException("Unable to create output directory:" + this.output, e);
            }
        }
        if (type == null && new File(this.output).isFile()) {
            Logger.getDEFAULT().printlnDebug("Trying to make certificate file type from the output.");
            type = CloudUtil.getFileExtension(this.output);
            if (type == null || type.length() != 3) {
                Logger.getDEFAULT().printlnWarning("The output file extension is not valid.");
            }
        }
        if (type == null) {
            type = this.aliases != null && this.aliases.size() == 1 ? "cer" : "jks";
            Logger.getDEFAULT().printlnDebug("Assumed cert file type:" + type);
        }
        try {
            try {
                this.cert_type = CERT_TYPE.valueOf(type.toUpperCase());
            }
            catch (Exception e) {
                throw new Exception(NLSUtil.localizeMessage("NLS_OPTION_VALUE_INVALID_FOR_POSSIBLE_VALUES", new Object[]{"certfiletype", type, CloudUtil.getCommaSeparatedListOfString(CloudUtil.getEnumValuesAsList(CERT_TYPE.class))}));
            }
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
        if (this.cert_type == CERT_TYPE.CER && (this.aliases == null || this.aliases.size() != 1) && new File(this.output).isFile()) {
            throw new CliException("Multiple certificates cannot be downloaded into single certificate file. Either use " + (Object)((Object)CERT_TYPE.JKS) + " or " + (Object)((Object)CERT_TYPE.PEM) + " as -" + "certfiletype" + " or specify exactly one alias. Alternatively, you can also specify a directory instead of a file for the argument -" + "output");
        }
        if (new File(this.output).isFile() && (ext = CloudUtil.getFileExtension(this.output)) != null && !this.cert_type.toString().equalsIgnoreCase(ext)) {
            Logger.getDEFAULT().printlnWarning("The output file extension '" + ext + "'  and the certificate file type '" + this.cert_type.toString() + "' do not match.");
        }
    }

    @Override
    public void invoke(ServiceManager client) throws Exception {
        throw new RuntimeException("Not to be called ...");
    }

    @Override
    public <T extends Service> Class<T> getServiceClass() {
        throw new RuntimeException("Not to be called ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(CertificateService c) throws Exception {
        block16: {
            if (this.aliases == null || this.aliases.isEmpty()) {
                this.aliases = CertificateServiceExtension.getExtensionFor(c).listAllAliases();
            }
            if (this.cert_type == CERT_TYPE.CER) {
                for (String alias : this.aliases) {
                    Certificate cert = c.describeCertificate(alias);
                    if (new File(this.output).isFile()) {
                        CloudUtil.writeToFile(new File(this.output), cert.getContents());
                        Logger.getDEFAULT().printlnInfo("Downloaded at:" + this.output);
                        continue;
                    }
                    CloudUtil.writeToFile(new File(this.output, alias + ".cer"), cert.getContents());
                    Logger.getDEFAULT().printlnInfo("Downloaded at:" + new File(this.output, alias + ".cer").getAbsolutePath());
                }
                break block16;
            }
            if (!new File(this.output).isFile()) {
                this.output = new File(this.output, "downloaded_certificates." + this.cert_type.toString().toLowerCase()).getAbsolutePath();
            }
            this.output = CloudUtil.validateOutputFile(this.output, true).getAbsolutePath();
            CertificateServiceExtension ext = CertificateServiceExtension.getExtensionFor(c);
            int count = 0;
            if (this.cert_type == CERT_TYPE.PEM) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(out);
                count = ext.downloadCertificatesAsPEM(this.aliases, writer);
                ((Writer)writer).flush();
                CloudUtil.writeToFile(new File(this.output), out.toByteArray());
            } else {
                KeyStore ks = ext.downloadCertificatesAsJKS(this.aliases);
                count = ks.size();
                FileOutputStream file = null;
                try {
                    file = new FileOutputStream(this.output);
                    ks.store(file, new char[0]);
                    file.flush();
                }
                finally {
                    if (file != null) {
                        ((OutputStream)file).close();
                    }
                }
            }
            if (count == 0) {
                throw new Exception("No certificates downloaded.");
            }
            Logger.getDEFAULT().printlnInfo(count + " certificates downloaded.");
            Logger.getDEFAULT().printlnInfo("Downloaded at:" + this.output);
        }
    }

    public static enum CERT_TYPE {
        CER,
        PEM,
        JKS;

    }
}

