/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common;

import java.util.Date;
import java.util.List;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloudlogic.javaservice.common.clibase.display.Cell;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.display.HeaderCell;
import oracle.cloudlogic.javaservice.common.clibase.display.Row;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.TimeUtils;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.CertificateDescription;
import oracle.cloudlogic.javaservice.types.CredentialMapType;
import oracle.cloudlogic.javaservice.types.CredentialType;
import oracle.cloudlogic.javaservice.types.JndiNameType;

public class CommonBeanUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printGridAsList(Grid g, String title, boolean list) {
        if (list) {
            Logger.getDEFAULT().println("Listing " + g.getRows().size() + " " + title);
        } else {
            Logger.getDEFAULT().println("Describing " + title);
        }
        List<NameValuePair<String, HeaderCell>> headers = g.getColumns().getList();
        for (Row r : g.getRows()) {
            OrderedMap<String, String> orderedMap = Logger.getDEFAULT().initMapText();
            synchronized (orderedMap) {
                Logger.getDEFAULT().addMapText("-----------", "-----------------------");
                int cellCount = 0;
                for (Cell c : r.getCells()) {
                    if (c.getContents() != null) {
                        Logger.getDEFAULT().addMapText(headers.get(cellCount).getName(), CloudUtil.getSeparatedListOfString(c.getContents(), "", "", false, "\n"));
                    } else if (c.getInnderGrid() != null) {
                        Logger.getDEFAULT().addMapText("#" + headers.get(cellCount).getName(), c.getInnderGrid().getRows().size());
                    } else {
                        Logger.getDEFAULT().addMapText(headers.get(cellCount).getName(), c.getContent());
                    }
                    ++cellCount;
                }
                Logger.getDEFAULT().addMapText("-----------", "-----------------------");
                Logger.getDEFAULT().endMapText();
                Logger.getDEFAULT().println();
            }
        }
    }

    public static Grid credentialsAsGrid(List<CredentialType> list) {
        Grid g = new Grid();
        g.addColumn("S.NO");
        g.addColumn("Key");
        g.addColumn("User");
        g.addColumn("Description");
        int count = 0;
        for (CredentialType ct : list) {
            Row r = g.createNewRow();
            r.setObjectAt(String.valueOf(++count), 0);
            r.setObjectAt(ct.getKey(), 1);
            r.setObjectAt(ct.getUser(), 2);
            r.setObjectAt(ct.getDescription(), 3);
        }
        return g;
    }

    public static void printCredentials(List<CredentialType> list, String title, boolean grid, int gridwidth) {
        if (list.isEmpty()) {
            Logger.getDEFAULT().printlnInfo("There is no credential.");
        } else {
            Grid g = CommonBeanUtil.credentialsAsGrid(list);
            if (grid) {
                BeanUtils.printGridRecursive(g, "Credential(s)" + title, gridwidth, true);
            } else {
                CommonBeanUtil.printGridAsList(g, "Credential(s)", true);
            }
        }
    }

    public static void printCertificates(List<CertificateDescription> list, boolean verbose, String title, boolean grid, int gridwidth, String type) {
        if (list.isEmpty()) {
            Logger.getDEFAULT().printlnInfo("There is no map.");
        } else {
            Grid g = new Grid();
            g.addColumn("S.NO");
            g.addColumn("Alias");
            g.addColumn("Expired");
            g.addColumn("Expiring in");
            if (verbose) {
                g.addColumn("Expiry Date");
                g.addColumn("DN");
            }
            int count = 0;
            Date current = new Date();
            for (CertificateDescription ct : list) {
                int col = 0;
                Row r = g.createNewRow();
                r.setObjectAt(String.valueOf(++count), col++);
                r.setObjectAt(ct.getAlias(), col++);
                if (ct.getExpiry() == null) {
                    r.setObjectAt("Expiry date not available", col++);
                    ++col;
                } else if (current.after(ct.getExpiry())) {
                    r.setObjectAt(TimeUtils.millisToLongDHMS(current.getTime() - ct.getExpiry().getTime(), false) + " ago", col++);
                    ++col;
                } else {
                    int n = ++col;
                    ++col;
                    r.setObjectAt(TimeUtils.millisToLongDHMS(ct.getExpiry().getTime() - current.getTime(), false), n);
                }
                if (!verbose) continue;
                r.setObjectAt(ct.getExpiry(), col++);
                r.setObjectAt(ct.getDn(), col++);
            }
            g.removeEmptyColumns();
            if (grid) {
                BeanUtils.printGridRecursive(g, type + " Certificate(s)" + title, gridwidth, true);
            } else {
                CommonBeanUtil.printGridAsList(g, type + " Certificate(s)", true);
            }
        }
    }

    public static void printCredentialMaps(List<CredentialMapType> list, String title, boolean grid, int gridwidth) {
        if (list.isEmpty()) {
            Logger.getDEFAULT().printlnInfo("There is no map.");
        } else {
            Grid g = new Grid();
            g.addColumn("S.NO");
            g.addColumn("Map");
            g.addColumn("Credentials");
            int count = 0;
            for (CredentialMapType ct : list) {
                Row r = g.createNewRow();
                r.setObjectAt(String.valueOf(++count), 0);
                r.setObjectAt(ct.getName(), 1);
                r.setObjectAt(CommonBeanUtil.credentialsAsGrid(ct.getCredentials()), 2);
            }
            if (grid) {
                BeanUtils.printGridRecursive(g, "Credential Map(s)" + title, gridwidth, true);
            } else {
                CommonBeanUtil.printGridAsList(g, "Credential Map(s)", true);
            }
        }
    }

    public static Grid dsJndiNamesAsGrid(List<JndiNameType> list) {
        Grid g = new Grid();
        g.addColumn("S.NO");
        g.addColumn("Jndi Alias");
        g.addColumn("ReadOnly");
        int count = 0;
        for (JndiNameType jnt : list) {
            Row r = g.createNewRow();
            r.setObjectAt(String.valueOf(++count), 0);
            r.setObjectAt(jnt.getName(), 1);
            r.setObjectAt(jnt.isReadonly(), 2);
        }
        return g;
    }

    public static void printDSJndiNames(List<JndiNameType> list, String title, boolean grid, int gridwidth) {
        if (list.isEmpty()) {
            Logger.getDEFAULT().printlnInfo("There are no JNDI aliases.");
        } else {
            Grid g = CommonBeanUtil.dsJndiNamesAsGrid(list);
            if (grid) {
                BeanUtils.printGridRecursive(g, "DS JNDI Alias(es)" + title, gridwidth, true);
            } else {
                CommonBeanUtil.printGridAsList(g, "DS JNDI Alias(es)", true);
            }
        }
    }
}

