/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.io.InputStream;
import java.util.Properties;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.executor.CliExecutor;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class VersionProvider
implements CliExecutor {
    private CommandLine command;
    private static final String Version_Path = "/config/version.properties";
    private static final String TOOL_VERSION_PROP = "JAVACLOUD-VERSION";
    private static final String TOOL_NAME_PROP = "JAVACLOUD-NAME";

    @Override
    public void setCommandLine(CommandLine command) {
        this.command = command;
    }

    @Override
    public void validate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        InputStream versionin = this.getClass().getResourceAsStream(Version_Path);
        if (versionin == null) {
            Logger.getDEFAULT().printlnWarning("The resource /config/version.properties is not found.");
            return;
        }
        Properties p = new Properties();
        try {
            p.load(versionin);
        }
        finally {
            versionin.close();
        }
        String toolversion = p.getProperty(TOOL_VERSION_PROP);
        String toolnamme = p.getProperty(TOOL_NAME_PROP);
        Logger.getDEFAULT().println(toolnamme);
        Logger.getDEFAULT().println("Version:" + toolversion);
    }
}

