/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import oracle.cloud.paas.client.cli.command.LibraryJobBaseExecutor;
import oracle.cloud.paas.model.Library;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;

public abstract class UploadLibrary
extends LibraryJobBaseExecutor {
    protected File file = null;
    protected String serviceID = null;
    protected Library library = null;
    private String libraryName = null;
    private String libraryDeployType = null;
    private String librarySpecVersion = null;
    private String libraryImplVersion = null;
    private String libraryType = null;
    private String DomainName = null;
    private String InstanceName = null;

    protected String getExtension() {
        String fileName = this.file.getName();
        int index = fileName.lastIndexOf(".");
        if (index < 0) {
            return "";
        }
        return fileName.substring(index + 1, fileName.length());
    }

    protected String getBaseName() {
        String fileName = this.file.getName();
        int index = fileName.lastIndexOf(".");
        if (index < 0) {
            return "";
        }
        return fileName.substring(0, index);
    }

    protected Map<String, String> getManifestInfo(String path) {
        HashMap<String, String> manifestInfo = Collections.EMPTY_MAP;
        try {
            URL url = new File(path).toURI().toURL();
            InputStream is = url.openStream();
            if (is != null) {
                JarInputStream jis = new JarInputStream(is);
                Manifest manifest = jis.getManifest();
                Attributes mainAttribs = manifest.getMainAttributes();
                String mfName = mainAttribs.getValue("Extension-Name");
                String mfSpec = mainAttribs.getValue("Specification-Version");
                String mfImpl = mainAttribs.getValue("Implementation-Version");
                manifestInfo = new HashMap<String, String>(3);
                manifestInfo.put("Extension-Name", mfName);
                manifestInfo.put("Specification-Version", mfSpec);
                manifestInfo.put("Implementation-Version", mfImpl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return manifestInfo;
    }

    @Override
    public void validate() throws CliException {
        try {
            Map<String, String> manifestInfo = Collections.EMPTY_MAP;
            super.validate();
            this.serviceID = this.command.getArgValue("serviceinstance");
            String archivePath = this.command.getArgValue("path");
            manifestInfo = this.getManifestInfo(archivePath);
            this.file = CloudUtil.validateInputFile(archivePath, "path");
            this.libraryName = manifestInfo.get("Extension-Name");
            if (this.libraryName == null || this.libraryName.trim().isEmpty()) {
                this.libraryName = this.command.getArgValue("library");
            }
            if (this.libraryName == null || this.libraryName.trim().isEmpty()) {
                throw new CliException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", "library"));
            }
            this.librarySpecVersion = manifestInfo.get("Specification-Version");
            if (this.librarySpecVersion == null || this.librarySpecVersion.trim().isEmpty()) {
                this.librarySpecVersion = this.command.getArgValue("specversion");
            }
            if (this.librarySpecVersion == null || this.librarySpecVersion.trim().isEmpty()) {
                throw new CliException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", "specversion"));
            }
            this.libraryImplVersion = manifestInfo.get("Implementation-Version");
            if (this.libraryImplVersion == null || this.libraryImplVersion.trim().equals("")) {
                this.libraryImplVersion = this.command.getArgValue("implversion");
            }
            if (this.libraryImplVersion == null || this.libraryImplVersion.trim().equals("")) {
                throw new CliException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", "implversion"));
            }
            this.DomainName = this.command.getArgValue("identitydomain");
            if (this.DomainName == null || this.DomainName.trim().equals("")) {
                throw new CliException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", "identitydomain"));
            }
            this.InstanceName = this.command.getArgValue("serviceinstance");
            if (this.InstanceName == null || this.InstanceName.trim().equals("")) {
                throw new CliException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", "serviceinstance"));
            }
            this.library = new Library();
            this.library.setDomainName(this.DomainName);
            this.library.setInstanceName(this.InstanceName);
            this.library.setName(this.libraryName);
            this.library.setSpecVersion(this.librarySpecVersion);
            this.library.setImplVersion(this.libraryImplVersion);
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }
}

