/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.io.File;
import oracle.cloud.paas.client.cli.command.ApplicationJobBaseExecutor;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;

public abstract class UploadApplication
extends ApplicationJobBaseExecutor {
    protected File file = null;
    protected String serviceID = null;
    protected String applicationName = null;
    protected boolean adminstate = false;

    protected String getExtension() {
        String fileName = this.file.getName();
        int index = fileName.lastIndexOf(".");
        if (index < 0) {
            return "";
        }
        return fileName.substring(index + 1, fileName.length());
    }

    protected String getBaseName() {
        String fileName = this.file.getName();
        int index = fileName.lastIndexOf(".");
        if (index < 0) {
            return "";
        }
        return fileName.substring(0, index);
    }

    @Override
    public void validate() throws CliException {
        try {
            super.validate();
            this.adminstate = this.command.getValueAsBoolean("adminstate");
            this.serviceID = this.command.getArgValue("serviceinstance");
            String archivePath = this.command.getArgValue("path");
            this.file = CloudUtil.validateInputFile(archivePath, "path");
            this.applicationName = this.command.getArgValue("application");
            if (this.applicationName == null || this.applicationName.trim().equals("")) {
                this.applicationName = this.getBaseName();
                if (this.applicationName == null || this.applicationName.trim().equals("")) {
                    throw new CliException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", "application"));
                }
            }
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }
}

