/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.Date;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.command.ApplicationJobBaseExecutor;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class UninstallApplication
extends ApplicationJobBaseExecutor {
    String serviceID = null;
    String applicationID = null;

    @Override
    public void validate() throws CliException {
        try {
            super.validate();
            this.serviceID = this.command.getArgValue("serviceinstance");
            this.applicationID = this.command.getArgValue("application");
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    @Override
    public void createJob(ApplicationManager client) throws Exception {
        this.createdJob = client.undeployApplication(this.tenantID, this.serviceID, this.applicationID);
        if (this.createdJob == null) {
            throw new Exception("The application could not be un-installed");
        }
        if (this.isLocal() && !this.isOnUi()) {
            Logger.getDEFAULT().printlnInfo("The application is un-installed");
        } else {
            Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_APP_REMOVE");
            BeanUtils.print(this.createdJob, 1, false, false, new Date(), null);
        }
    }
}

