/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.Date;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.command.ApplicationJobBaseExecutor;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class RestartServiceInstanceExecutor
extends ApplicationJobBaseExecutor {
    protected boolean force = false;
    protected String serviceID = null;
    protected int timeoutInsSecs = 180;

    @Override
    public void createJob(ApplicationManager client) throws Exception {
        this.createdJob = client.restartService(this.tenantID, this.serviceID, this.force, (long)(this.timeoutInsSecs * 1000));
        if (this.createdJob == null) {
            throw new Exception("Service could not be started");
        }
        if (this.isLocal() && !this.isOnUi()) {
            Logger.getDEFAULT().printlnInfo("The service is re-started");
        } else {
            Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_SERVICE_RESTART");
            BeanUtils.print(this.createdJob, 1, false, false, new Date(), null);
        }
    }

    @Override
    public void validate() throws CliException {
        super.validate();
        this.force = this.command.getValueAsBoolean("force");
        this.serviceID = this.command.getArgValue("serviceinstance");
        String lim = this.command.getArgValue("timeout");
        if (lim != null && !lim.trim().equals("")) {
            try {
                int given = Integer.parseInt(lim);
                if (given < this.timeoutInsSecs) {
                    throw new CliException("Timeout cannot be less than 180 seconds");
                }
                this.timeoutInsSecs = given;
            }
            catch (NumberFormatException e) {
                throw new CliException("Please enter valid value for timeout", e);
            }
        }
    }
}

