/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.Collections;
import java.util.List;
import oracle.cloud.paas.api.LibraryManager;
import oracle.cloud.paas.client.cli.bean.LibraryComparator;
import oracle.cloud.paas.client.cli.bean.LibraryPrintUtils;
import oracle.cloud.paas.client.cli.command.LibraryBaseExecutor;
import oracle.cloud.paas.model.Library;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;

public class ListLibraries
extends LibraryBaseExecutor {
    LibraryComparator.FIELD sortField = null;
    List<Library> list = null;

    @Override
    public void validate() throws CliException {
        block4: {
            super.validate();
            try {
                if (this.sorton == null || this.sorton.trim().equals("")) break block4;
                try {
                    this.sortField = LibraryComparator.FIELD.valueOf(this.sorton.toUpperCase());
                }
                catch (Exception e) {
                    throw new Exception(NLSUtil.localizeMessage("NLS_OPTION_VALUE_INVALID_FOR_POSSIBLE_VALUES", new Object[]{"sorton", this.sorton, CloudUtil.getCommaSeparatedListOfString(CloudUtil.getEnumValuesAsList(LibraryComparator.FIELD.class))}));
                }
            }
            catch (Exception e) {
                throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
            }
        }
    }

    @Override
    public void invoke(LibraryManager client) throws Exception {
        this.list = client.listLibraries(this.tenantID, this.serviceID);
        if (this.sortField != null) {
            Collections.sort(this.list, new LibraryComparator(this.sortField, this.descending));
        }
        LibraryPrintUtils.printLibraries("identity domain= " + this.tenantID + ", service instance= " + this.serviceID, this.list, this.grid, this.gridWidth, this.full, true, 0);
    }

    public List<Library> getList() {
        return this.list;
    }
}

