/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import oracle.cloud.paas.client.ClientConstants;
import oracle.cloud.paas.client.cli.command.common.fs.FSMain;
import oracle.cloud.paas.client.cli.command.common.wlst.WLSTMain;
import oracle.cloud.paas.doc.JavaCloud;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.MainBase;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.executor.CliExecutor;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class HtmlUsagePageGenerator
implements CliExecutor,
ClientConstants {
    private String dir = null;
    private CommandLine command;
    private MainBase mainToBePrinted = null;
    public static String FILE_NAME = "usage.html";
    public static String FILE_NAME_XML = "usage.xml";
    private String fileName = null;
    private boolean xml = false;

    public HtmlUsagePageGenerator() {
    }

    public HtmlUsagePageGenerator(MainBase base) {
        this.mainToBePrinted = base;
    }

    @Override
    public void setCommandLine(CommandLine command) {
        this.command = command;
    }

    @Override
    public void validate() throws CliException {
        this.xml = this.command.getValueAsBoolean("xml");
        this.fileName = this.xml ? FILE_NAME_XML : FILE_NAME;
        this.dir = this.command.getArgValue("output", "./");
        if (this.dir == null) {
            throw new CliException("output should be specified");
        }
        try {
            this.dir = CloudUtil.validateOutputDir(this.dir).getAbsolutePath();
        }
        catch (Exception e) {
            File file = new File(this.dir);
            if (file.exists() && file.isFile()) {
                this.dir = file.getParentFile().getAbsolutePath();
                this.fileName = file.getName();
            }
            throw new CliException(e.getMessage(), e);
        }
    }

    @Override
    public void execute() throws Exception {
        if (this.command.getValueAsBoolean("fsdoc")) {
            this.mainToBePrinted = FSMain.createWith(null);
        } else if (this.command.getValueAsBoolean("appconfigdoc")) {
            this.mainToBePrinted = WLSTMain.createWith(null);
        }
        if (this.mainToBePrinted == null) {
            this.mainToBePrinted = MainBase.getMain();
        }
        if (this.mainToBePrinted == null) {
            throw new Exception("Main is not registered.");
        }
        Logger.getDEFAULT().printlnInfoI18n("INFO_PRINTING_FILE_AT", this.fileName, this.dir);
        if (!this.xml) {
            this.mainToBePrinted.writeHelpHtml(new File(this.dir, this.fileName).getAbsolutePath());
        } else {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{JavaCloud.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            File f = new File(this.dir, this.fileName);
            m.marshal((Object)new JavaCloud(), f);
        }
    }

    public void setMainToBePrinted(MainBase mainToBePrinted) {
        this.mainToBePrinted = mainToBePrinted;
    }

    public MainBase getMainToBePrinted() {
        return this.mainToBePrinted;
    }
}

