/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.Date;
import java.util.List;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.command.ApplicationJobBaseExecutor;
import oracle.cloud.paas.exception.ManagerException;
import oracle.cloud.paas.model.JobStatus;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;

public class DescribeJob
extends ApplicationJobBaseExecutor {
    protected String jobId;

    @Override
    public void validate() throws CliException {
        try {
            super.validate();
            this.jobId = this.command.getArgValue("jobid");
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    @Override
    public void createJob(ApplicationManager client) throws Exception {
        if (this.isLocal() && !this.isOnUi()) {
            throw new ManagerException("Un-supported operation from CLI against local domain");
        }
        this.createdJob = client.describeJob(this.jobId);
        if (this.createdJob == null) {
            throw new Exception("Could not find a job with the job-id:" + this.jobId);
        }
        List logs = null;
        if (this.createdJob.getStatus() == JobStatus.FAILED) {
            logs = client.listJobLogs(this.jobId);
        }
        BeanUtils.print(this.createdJob, 1, true, this.isLocal() && !this.isOnUi(), new Date(), logs);
    }

    public String getJobId() {
        return this.jobId;
    }
}

