/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.bean;

import java.util.List;
import oracle.cloud.paas.api.LibraryManager;
import oracle.cloud.paas.client.ClientConstants;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.model.Library;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.display.Row;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class LibraryPrintUtils
implements ClientConstants {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printLibraries(String title, List<Library> types, boolean grid, int width, boolean full, boolean list, int cols) {
        if (types == null || types.size() == 0) {
            Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_NO_LIBRARIES");
            Logger.getDEFAULT().printlnTipI18n("NLS_TIP_INSTALL", "install-library");
        } else if (!grid) {
            Logger logger = Logger.getDEFAULT();
            synchronized (logger) {
                int diff = Logger.getDEFAULT().tab(cols);
                if (list) {
                    Logger.getDEFAULT().println();
                    if (types.size() == 1) {
                        Logger.getDEFAULT().println(NLSUtil.localizeMessage("NLS_INFO_ONE_LIBRARY"));
                    } else {
                        Logger.getDEFAULT().printlnI18n("NLS_INFO_MORE_LIBRARIES", String.valueOf(types.size()));
                    }
                }
                int count = 1;
                for (Library obj : types) {
                    cols = LibraryPrintUtils.print(obj, count, full, cols);
                    ++count;
                }
                Logger.getDEFAULT().shiftTab(diff);
            }
        } else {
            Grid g = new Grid();
            g.addColumn("#");
            g.addColumn("Library Name");
            g.addColumn("State");
            g.addColumn("Deploy Type");
            g.addColumn("Spec Version");
            if (full) {
                g.addColumn("Impl Version");
                g.addColumn("Type");
            }
            int count = 1;
            for (Library obj : types) {
                Row r = g.createNewRow();
                int col = 0;
                r.setValueAt(String.valueOf(count), col++);
                r.setValueAt(obj.getName(), col++);
                r.setValueAt(obj.getState().toString(), col++, true);
                r.setObjectAt(obj.getDeployType(), col++);
                r.setValueAt(obj.getSpecVersion(), col++);
                if (full) {
                    r.setValueAt(obj.getImplVersion(), col++);
                    r.setObjectAt(obj.getType(), col++);
                }
                ++count;
            }
            if (list) {
                BeanUtils.printGridRecursive(g, (types.size() == 1 ? "library" : "libraries") + " under " + title, width, list);
            } else {
                BeanUtils.printGridRecursive(g, "library " + title, width, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printReferenceApps(LibraryManager client, String title, List<Library> types, boolean grid, int width, boolean full, boolean list, int cols) {
        if (types == null || types.size() == 0) {
            Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_NO_LIBRARIES");
            Logger.getDEFAULT().printlnTipI18n("NLS_TIP_INSTALL", "install-library");
        } else if (!grid) {
            Logger logger = Logger.getDEFAULT();
            synchronized (logger) {
                int diff = Logger.getDEFAULT().tab(cols);
                if (list) {
                    Logger.getDEFAULT().println();
                    if (types.size() == 1) {
                        Logger.getDEFAULT().println(NLSUtil.localizeMessage("NLS_INFO_ONE_LIBRARY"));
                    } else {
                        Logger.getDEFAULT().printlnI18n("NLS_INFO_MORE_LIBRARIES", String.valueOf(types.size()));
                    }
                }
                int count = 1;
                for (Library obj : types) {
                    cols = LibraryPrintUtils.printLibReferenceAppNonGrid(client, obj, count, full, cols);
                    ++count;
                }
                Logger.getDEFAULT().shiftTab(diff);
            }
        } else {
            Grid g = new Grid();
            g.addColumn("#");
            g.addColumn("Library Name");
            g.addColumn("State");
            g.addColumn("Deploy Type");
            g.addColumn("Spec Version");
            g.addColumn("Referencing Applications");
            if (full) {
                g.addColumn("Impl Version");
                g.addColumn("Type");
            }
            int count = 1;
            for (Library obj : types) {
                Row r = g.createNewRow();
                int col = 0;
                r.setValueAt(String.valueOf(count), col++);
                r.setValueAt(obj.getName(), col++);
                r.setValueAt(obj.getState().toString(), col++, true);
                r.setObjectAt(obj.getDeployType(), col++);
                r.setValueAt(obj.getSpecVersion(), col++);
                r.setContents(client.getReferencingApplicationNames(obj), col++);
                if (full) {
                    r.setValueAt(obj.getImplVersion(), col++);
                    r.setObjectAt(obj.getType(), col++);
                }
                ++count;
            }
            if (list) {
                BeanUtils.printGridRecursive(g, (types.size() == 1 ? "library" : "libraries") + " under " + title, width, list);
            } else {
                BeanUtils.printGridRecursive(g, "library " + title, width, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int print(Library obj, int count, boolean full, int cols) {
        Logger logger = Logger.getDEFAULT();
        synchronized (logger) {
            int diff = Logger.getDEFAULT().tab(cols);
            Logger.getDEFAULT().println();
            OrderedMap<String, String> orderedMap = Logger.getDEFAULT().initMapText();
            synchronized (orderedMap) {
                Logger.getDEFAULT().addMapText("-----------", "-----------------------");
                Logger.getDEFAULT().addMapText(count + ":Library Name", obj.getName());
                Logger.getDEFAULT().addMapText("State", obj.getState().toString());
                Logger.getDEFAULT().addMapText("Deploy Type", obj.getDeployType() == null ? " " : String.valueOf(obj.getDeployType()));
                Logger.getDEFAULT().addMapText("Spec Version", obj.getSpecVersion().toString());
                if (full) {
                    Logger.getDEFAULT().addMapText("Impl Version", obj.getImplVersion().toString());
                    Logger.getDEFAULT().addMapText("Library Type", obj.getType() == null ? " " : String.valueOf(obj.getType()));
                    Logger.getDEFAULT().addMapText("Identity Domain", obj.getDomainName());
                    Logger.getDEFAULT().addMapText("Service Instance", obj.getInstanceName());
                }
                Logger.getDEFAULT().addMapText("----------- ", "-----------------------");
                cols = Logger.getDEFAULT().endMapText();
            }
            Logger.getDEFAULT().shiftTab(diff);
        }
        return cols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int printLibReferenceAppNonGrid(LibraryManager client, Library obj, int count, boolean full, int cols) {
        Logger logger = Logger.getDEFAULT();
        synchronized (logger) {
            int diff = Logger.getDEFAULT().tab(cols);
            Logger.getDEFAULT().println();
            OrderedMap<String, String> orderedMap = Logger.getDEFAULT().initMapText();
            synchronized (orderedMap) {
                Logger.getDEFAULT().addMapText("-----------", "-----------------------");
                Logger.getDEFAULT().addMapText(count + ":Library Name", obj.getName());
                Logger.getDEFAULT().addMapText("State", obj.getState().toString());
                Logger.getDEFAULT().addMapText("Deploy Type", obj.getDeployType() == null ? " " : String.valueOf(obj.getDeployType()));
                Logger.getDEFAULT().addMapText("Spec Version", obj.getSpecVersion().toString());
                Logger.getDEFAULT().addMapText("Referencing Applications", CloudUtil.getSeparatedListOfString(client.getReferencingApplicationNames(obj), "", "", false, "\n\n"));
                if (full) {
                    Logger.getDEFAULT().addMapText("Impl Version", obj.getImplVersion().toString());
                    Logger.getDEFAULT().addMapText("Library Type", obj.getType() == null ? " " : String.valueOf(obj.getType()));
                    Logger.getDEFAULT().addMapText("Identity Domain", obj.getDomainName());
                    Logger.getDEFAULT().addMapText("Service Instance", obj.getInstanceName());
                }
                Logger.getDEFAULT().addMapText("----------- ", "-----------------------");
                cols = Logger.getDEFAULT().endMapText();
            }
            Logger.getDEFAULT().shiftTab(diff);
        }
        return cols;
    }
}

