/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaScriptElementImageDescriptor;

public class MethodDeclarationCompletionProposal
extends JavaTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private final IType fType;
    private final String fReturnTypeSig;
    private final String fMethodName;

    public static void evaluateProposals(IType type, String prefix, int offset, int length, int relevance, Set suggestedMethods, Collection result) throws CoreException {
        IFunction[] methods = type.getFunctions();
        String constructorName = type.getElementName();
        if (constructorName.length() > 0 && constructorName.startsWith(prefix) && !MethodDeclarationCompletionProposal.hasMethod(methods, constructorName) && suggestedMethods.add(constructorName)) {
            result.add(new MethodDeclarationCompletionProposal(type, constructorName, null, offset, length, relevance + 500));
        }
        if (prefix.length() > 0 && !"main".equals(prefix) && !MethodDeclarationCompletionProposal.hasMethod(methods, prefix) && suggestedMethods.add(prefix) && !JavaScriptConventions.validateFunctionName((String)prefix).matches(4)) {
            result.add(new MethodDeclarationCompletionProposal(type, prefix, "V", offset, length, relevance));
        }
    }

    private static boolean hasMethod(IFunction[] methods, String name) {
        int i = 0;
        while (i < methods.length) {
            IFunction curr = methods[i];
            if (curr.getElementName().equals(name) && curr.getParameterTypes().length == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public MethodDeclarationCompletionProposal(IType type, String methodName, String returnTypeSig, int start, int length, int relevance) {
        super("", type.getJavaScriptUnit(), start, length, null, MethodDeclarationCompletionProposal.getDisplayName(methodName, returnTypeSig), relevance);
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)methodName);
        this.fType = type;
        this.fMethodName = methodName;
        this.fReturnTypeSig = returnTypeSig;
        if (returnTypeSig == null) {
            this.setProposalInfo(new ProposalInfo((IMember)type));
            JavaScriptElementImageDescriptor desc = new JavaScriptElementImageDescriptor(JavaPluginImages.DESC_MISC_PUBLIC, 512, JavaElementImageProvider.SMALL_SIZE);
            this.setImage(JavaScriptPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc));
        } else {
            this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.methpri_obj.gif"));
        }
    }

    private static String getDisplayName(String methodName, String returnTypeSig) {
        StringBuffer buf = new StringBuffer();
        buf.append(methodName);
        buf.append('(');
        buf.append(')');
        if (returnTypeSig != null) {
            buf.append("  ");
            buf.append(Signature.toString((String)returnTypeSig));
            buf.append(" - ");
            buf.append(JavaTextMessages.MethodCompletionProposal_method_label);
        } else {
            buf.append(" - ");
            buf.append(JavaTextMessages.MethodCompletionProposal_constructor_label);
        }
        return buf.toString();
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportRewrite impRewrite) throws CoreException, BadLocationException {
        String comment;
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.fType.getJavaScriptProject());
        boolean addComments = settings.createComments;
        String[] empty = new String[]{};
        String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        String declTypeName = this.fType.getTypeQualifiedName('.');
        StringBuffer buf = new StringBuffer();
        if (addComments && (comment = CodeGeneration.getMethodComment(this.fType.getJavaScriptUnit(), declTypeName, this.fMethodName, empty, empty, this.fReturnTypeSig, null, lineDelim)) != null) {
            buf.append(comment);
            buf.append(lineDelim);
        }
        if (this.fReturnTypeSig != null) {
            buf.append("private ");
        } else {
            buf.append("public ");
        }
        if (this.fReturnTypeSig != null) {
            buf.append(Signature.toString((String)this.fReturnTypeSig));
        }
        buf.append(' ');
        buf.append(this.fMethodName);
        buf.append("() {");
        buf.append(lineDelim);
        String body = CodeGeneration.getMethodBodyContent(this.fType.getJavaScriptUnit(), declTypeName, this.fMethodName, this.fReturnTypeSig == null, "", lineDelim);
        if (body != null) {
            buf.append(body);
            buf.append(lineDelim);
        }
        buf.append("}");
        buf.append(lineDelim);
        String stub = buf.toString();
        IRegion region = document.getLineInformationOfOffset(this.getReplacementOffset());
        int lineStart = region.getOffset();
        int indent = Strings.computeIndentUnits(document.get(lineStart, this.getReplacementOffset() - lineStart), settings.tabWidth, settings.indentWidth);
        String replacement = CodeFormatterUtil.format(4, stub, indent, null, lineDelim, this.fType.getJavaScriptProject());
        if (replacement.endsWith(lineDelim)) {
            replacement = replacement.substring(0, replacement.length() - lineDelim.length());
        }
        this.setReplacementString(Strings.trimLeadingTabsAndSpaces(replacement));
        return true;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return new String();
    }

    public boolean isAutoInsertable() {
        return false;
    }
}

