/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.jws.model;

import oracle.eclipse.tools.common.ui.wizards.model.ContainerSelectionModel;
import oracle.eclipse.tools.webservices.ui.util.JavaResourceUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class JWSContainerSelectionModel
extends ContainerSelectionModel {
    public static final String PACKAGE_ROOT_PROPERTY = "PACKAGE_ROOT_PROPERTY";
    public static final String PACKAGE_PROPERTY = "PACKAGE_PROPERTY";
    private String packageRoot = "";
    private String pkg = "";

    public void setContainer(IContainer container) {
        String oldPackageRoot = this.packageRoot;
        String oldPackage = this.pkg;
        this.packageRoot = JWSContainerSelectionModel.getPackageRoot(JavaResourceUtil.getDefaultPackageRoot(container));
        this.pkg = JWSContainerSelectionModel.getPackage(JavaResourceUtil.getPackage(container));
        super.setContainer(container);
        this.firePropertyChange(PACKAGE_ROOT_PROPERTY, oldPackageRoot, this.packageRoot);
        this.firePropertyChange(PACKAGE_PROPERTY, oldPackage, this.pkg);
    }

    public String getPackageRoot() {
        return this.packageRoot;
    }

    public void setPackageRoot(String packageRoot) {
        if (packageRoot == null) {
            packageRoot = "";
        }
        packageRoot = packageRoot.trim();
        String oldValue = this.packageRoot;
        this.packageRoot = packageRoot;
        super.setContainer(this.getPackageContainer());
        this.firePropertyChange(PACKAGE_ROOT_PROPERTY, oldValue, packageRoot);
    }

    public IPackageFragmentRoot getPackageRootElement() {
        return JavaResourceUtil.getPackageRoot(this.getPackageRootContainer());
    }

    public void setPackageRoot(IPackageFragmentRoot packageRoot) {
        this.setPackageRoot(JWSContainerSelectionModel.getPackageRoot(packageRoot));
    }

    private IContainer getPackageRootContainer() {
        Path packageRootPath = new Path(this.getPackageRoot());
        if (packageRootPath.segmentCount() >= 2) {
            IFolder packageRootFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)packageRootPath);
            return packageRootFolder;
        }
        return null;
    }

    public String getPackage() {
        return this.pkg;
    }

    public void setPackage(String pkg) {
        if (pkg == null) {
            pkg = "";
        }
        pkg = pkg.trim();
        String oldValue = this.pkg;
        this.pkg = pkg;
        super.setContainer(this.getPackageContainer());
        this.firePropertyChange(PACKAGE_PROPERTY, oldValue, pkg);
    }

    public IPackageFragment getPackageElement() {
        return JavaResourceUtil.getPackage(this.getPackageContainer());
    }

    public void setPackage(IPackageFragment pkg) {
        this.setPackage(JWSContainerSelectionModel.getPackage(pkg));
    }

    private static String getPackage(IPackageFragment pkg) {
        String packageName = "";
        if (pkg != null) {
            packageName = pkg.getElementName();
        }
        return packageName;
    }

    private static String getPackageRoot(IPackageFragmentRoot packageRoot) {
        String packageRootString = "";
        if (packageRoot != null) {
            packageRootString = packageRoot.getPath().makeRelative().toString();
        }
        return packageRootString;
    }

    private IContainer getPackageContainer() {
        Path packagePath;
        IContainer container = this.getPackageRootContainer();
        if (container != null && (packagePath = new Path(this.getPackage().replace('.', '/'))).segmentCount() > 0) {
            container = container.getFolder((IPath)packagePath);
        }
        return container;
    }
}

