/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.jws;

import com.bea.wlw.template.ITemplateBean;
import com.bea.wlw.template.exceptions.GenerationFailedException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.common.templating.filetemplate.FormattingService;
import oracle.eclipse.tools.common.templating.template.core.TemplateService;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.ValidateEditUtil;
import oracle.eclipse.tools.common.util.fileio.FolderUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.template.WebServiceTemplateBean;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.PolicyWizardPage;
import oracle.eclipse.tools.webservices.ui.wizards.jws.model.IJWSExistingMethods;
import oracle.eclipse.tools.webservices.ui.wizards.jws.model.IJWSFromExistingModel;
import oracle.eclipse.tools.webservices.ui.wizards.jws.model.JWSFromExistingModelResource;
import oracle.eclipse.tools.webservices.ui.wizards.jws.model.JWSWriterContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class NewJWSFromExistingWizard
extends SapphireWizard<IJWSFromExistingModel>
implements IWorkbenchWizard {
    private IStructuredSelection selection;
    private WebServiceTemplateBean arguments = new WebServiceTemplateBean();
    private PolicyWizardPage policyPage;
    private JWSWriterContext jwsWriterContext;
    private IFile baseFile;
    private IFile seiFile;

    public NewJWSFromExistingWizard() {
        super((Element)NewJWSFromExistingWizard.createModel(), DefinitionLoader.sdef(NewJWSFromExistingWizard.class).wizard());
    }

    public IWizardPage[] getPages() {
        IWizardPage[] pages = super.getPages();
        IWizardPage[] extended = new IWizardPage[pages.length + 1];
        System.arraycopy(pages, 0, extended, 0, pages.length);
        if (this.policyPage == null) {
            this.policyPage = new PolicyWizardPage("PolicyPage", this.selection, this.arguments);
            this.policyPage.setWizard((IWizard)this);
        }
        extended[pages.length] = this.policyPage;
        return extended;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.baseFile = this.getFile();
        if (this.baseFile == null) {
            return;
        }
        ICompilationUnit icu = this.getIcu(this.baseFile);
        if (icu == null) {
            return;
        }
        this.arguments.setPackageName(NewJWSFromExistingWizard.getPackageName(this.baseFile.getParent()));
        this.arguments.setClassName(this.baseFile.getFullPath().removeFileExtension().lastSegment());
        this.seiFile = this.getSeiFile(this.baseFile);
        this.arguments.setSeiClassName(this.seiFile.getFullPath().removeFileExtension().lastSegment());
        this.jwsWriterContext = new JWSWriterContext(icu, this.arguments);
        IJWSFromExistingModel element = (IJWSFromExistingModel)this.element();
        JWSFromExistingModelResource resource = (JWSFromExistingModelResource)element.resource();
        resource.setContext(this.jwsWriterContext);
        HashMap<String, IMethod> mapSig = new HashMap<String, IMethod>();
        try {
            List<IMethod> methods = this.jwsWriterContext.getPublicITypeMethods();
            for (IMethod method : methods) {
                IJWSExistingMethods jwsMethod = (IJWSExistingMethods)element.getMethods().insert();
                String methodSignature = this.methodSignature(method);
                jwsMethod.setMethodName(methodSignature);
                mapSig.put(methodSignature, method);
            }
            resource.setMethodMap(mapSig);
        }
        catch (JavaModelException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
        }
    }

    protected Status performFinish(ProgressMonitor monitor) {
        this.policyPage.updateArguments();
        return super.performFinish(monitor);
    }

    protected void performPostFinish() {
        if (this.seiFile.exists()) {
            boolean cancelled;
            StringBuilder message = new StringBuilder(Messages.generated_files_validator_overwrite_msg);
            message.append("\n  ").append(this.seiFile.getFullPath().toPortableString());
            boolean bl = cancelled = !DialogService.showConfirmDialog((String)Messages.generated_files_validator_overwrite, (String)message.toString());
            if (cancelled) {
                return;
            }
            if (!ValidateEditUtil.validateEdit((IFile[])new IFile[]{this.baseFile, this.seiFile}).isOK()) {
                return;
            }
        } else if (!ValidateEditUtil.validateEdit((IFile[])new IFile[]{this.baseFile}).isOK()) {
            return;
        }
        this.jwsWriterContext.internalEndEdit();
        IFile fileHandle = (IFile)this.jwsWriterContext.getCompilationUnit().getResource();
        try {
            fileHandle.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
        }
        IJWSFromExistingModel jwsModel = (IJWSFromExistingModel)this.element();
        Boolean addSei = (Boolean)jwsModel.isAddSeiEnabled().content();
        if (addSei != null && addSei.booleanValue()) {
            try {
                this.generateTemplateFile(this.seiFile, this.arguments, "oracle.eclipse.tools.webservices.filetemplate.newSEIWebServiceExist", true, this.seiFile.exists());
                this.seiFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    public String methodSignature(IMethod method) throws JavaModelException {
        return Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)false, (boolean)false);
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    private IFile getFile() {
        Object obj;
        if (this.getSelection() != null && this.getSelection() instanceof IStructuredSelection && (obj = this.getSelection().getFirstElement()) instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)obj;
            IFile file = (IFile)a.getAdapter(IFile.class);
            return file;
        }
        return null;
    }

    private ICompilationUnit getIcu(IFile file) {
        IJavaElement elem = JavaCore.create((IFile)file);
        if (elem instanceof ICompilationUnit) {
            return (ICompilationUnit)elem;
        }
        return null;
    }

    private static final IJWSFromExistingModel createModel() {
        return (IJWSFromExistingModel)IJWSFromExistingModel.TYPE.instantiate((Resource)new JWSFromExistingModelResource(IJWSFromExistingModel.TYPE));
    }

    private static String getPackageName(IContainer container) {
        IJavaElement elem = JavaCore.create((IResource)container);
        if (elem instanceof IPackageFragmentRoot) {
            return "";
        }
        if (elem instanceof IPackageFragment) {
            return ((IPackageFragment)elem).getElementName();
        }
        return null;
    }

    private void generateTemplateFile(IFile file, WebServiceTemplateBean bean, String templateID, boolean force, boolean exists) throws GenerationFailedException, UnsupportedEncodingException, CoreException {
        String fileContents = TemplateService.generate((String)templateID, (ITemplateBean)bean);
        fileContents = FormattingService.formatSource((IProject)file.getProject(), (IPath)file.getLocation(), (String)fileContents);
        IProgressMonitor progressMonitor = null;
        ByteArrayInputStream stream = new ByteArrayInputStream(fileContents.getBytes(StandardCharsets.UTF_8));
        FolderUtil.ensureFolder((IFile)file, (boolean)false, progressMonitor);
        if (!exists) {
            file.create((InputStream)stream, force, progressMonitor);
        } else {
            file.setContents((InputStream)stream, force, true, progressMonitor);
        }
    }

    private IFile getSeiFile(IFile base) {
        IPath containerFilePath = base.getParent().getFullPath();
        if (containerFilePath == null) {
            return null;
        }
        IPath filePath = containerFilePath.append(this.getSeiFileName(base));
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        return file;
    }

    private String getSeiFileName(IFile base) {
        String result = base.getName();
        if (result.indexOf(46) < 0) {
            result = String.valueOf(result) + "PortType";
            result = String.valueOf(result) + ".java";
        } else {
            StringBuffer bufferResult = new StringBuffer(result);
            result = bufferResult.insert(result.indexOf(46), "PortType").toString();
        }
        return result;
    }
}

