/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.jaxb;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.jaxb.JaxbXJCArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.IAntWrapperPage;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFieldValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.InProjectValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledIFileSelector;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledPackageSelector;
import oracle.eclipse.tools.webservices.ui.wizards.common.ListOfFilesLocationGroup;
import oracle.eclipse.tools.webservices.ui.wizards.common.NeverUpdateStrategy;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class JaxbXJCOptionsPage
extends WizardPage
implements IAntWrapperPage {
    private static final String PAGE_NAME = JaxbXJCOptionsPage.class.getSimpleName();
    private String helpContextId;
    private Set<String> acceptableExtensions = new HashSet<String>();
    private JaxbXJCArguments arguments;
    private Composite composite;
    private DataBindingContext dataBindingContext = new DataBindingContext();
    private ListOfFilesLocationGroup bindingFiles;
    private final LabeledPackageSelector packageSelector;
    private LabeledIFileSelector xmlCatalog;
    private Button looseValidationBtn;
    private Button headerBtn;
    private ISWTObservableValue headerObservable;
    private Button includeSourceInJarBtn;
    private ISWTObservableValue includeSourceInJarObservable;

    public JaxbXJCOptionsPage(JaxbXJCArguments arguments, String helpContextId) {
        super(PAGE_NAME);
        this.arguments = arguments;
        this.helpContextId = helpContextId;
        this.setTitle(Messages.jaxb_xjc_options_page_title);
        this.setDescription(Messages.jaxb_xjc_options_page_desc);
        this.acceptableExtensions.addAll(IFieldValidator.xmlCatalogFile.getExtensions());
        this.packageSelector = new LabeledPackageSelector(Messages.jaxb_xjc_options_package_label, Messages.jaxb_xjc_options_package_tooltip, Messages.jaxb_xjc_options_package_title, Messages.jaxb_xjc_options_package_msg, (CommonWebServiceAntTaskArguments)arguments, "packageName");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setupVisualElements(parent);
        this.setupDataBindingAndValidation();
    }

    private void setupVisualElements(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.composite.setLayout((Layout)layout);
        this.packageSelector.createControl(this.composite);
        this.xmlCatalog = new LabeledIFileSelector(Messages.jaxb_xjc_option_catalog_label, Messages.jaxb_xjc_option_catalog_browse_dialog_title, Messages.jaxb_xjc_option_catalog_browse_dialog_desc, (CommonWebServiceAntTaskArguments)this.arguments, "catalog", null, true, IFieldValidator.optional, IFieldValidator.xmlCatalogFile, new InProjectValidator((CommonWebServiceAntTaskArguments)this.arguments));
        this.xmlCatalog.createControl(this.composite);
        this.bindingFiles = new ListOfFilesLocationGroup((CommonWebServiceAntTaskArguments)this.arguments, "bindings", Messages.jaxb_xjc_options_binding_label, Messages.jaxb_xjc_options_bindings_dialog_title, Messages.jaxb_xjc_options_bindings_dialog_msg, IFieldValidator.xmlJaxbBindings);
        this.bindingFiles.createControl(this.composite);
        new Label(this.composite, 0);
        this.includeSourceInJarBtn = new Button(this.composite, 32);
        this.includeSourceInJarBtn.setText(Messages.jaxb_xjc_options_include_src_in_jar_desc);
        this.includeSourceInJarBtn.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.includeSourceInJarBtn.setToolTipText(Messages.jaxb_xjc_options_include_src_in_jar_tooltip);
        new Label(this.composite, 0);
        this.looseValidationBtn = new Button(this.composite, 32);
        this.looseValidationBtn.setText(Messages.jaxb_xjc_options_nv_name);
        this.looseValidationBtn.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.looseValidationBtn.setToolTipText(Messages.jaxb_xjc_options_nv_tooltip);
        new Label(this.composite, 0);
        this.headerBtn = new Button(this.composite, 32);
        this.headerBtn.setText(Messages.jaxb_xjc_options_header_desc);
        this.headerBtn.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.headerBtn.setToolTipText(Messages.jaxb_xjc_options_header_tooltip);
        this.setControl((Control)this.composite);
        Dialog.applyDialogFont((Control)this.composite);
    }

    private void setupDataBindingAndValidation() {
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dataBindingContext);
        this.packageSelector.bindToContext(this.dataBindingContext);
        this.dataBindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.looseValidationBtn), BeansObservables.observeValue((Object)this.arguments, (String)"looseValidation"), new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_UPDATE), (UpdateValueStrategy)NeverUpdateStrategy.instance);
        this.headerObservable = SWTObservables.observeSelection((Control)this.headerBtn);
        this.headerObservable.setValue((Object)this.arguments.getHeader());
        this.dataBindingContext.bindValue((IObservableValue)this.headerObservable, BeansObservables.observeValue((Object)this.arguments, (String)"header"), new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_UPDATE), (UpdateValueStrategy)NeverUpdateStrategy.instance);
        this.includeSourceInJarObservable = SWTObservables.observeSelection((Control)this.includeSourceInJarBtn);
        this.includeSourceInJarObservable.setValue((Object)this.arguments.getIncludeSourceInJar());
        this.dataBindingContext.bindValue((IObservableValue)this.includeSourceInJarObservable, BeansObservables.observeValue((Object)this.arguments, (String)"includeSourceInJar"), new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_UPDATE), (UpdateValueStrategy)NeverUpdateStrategy.instance);
        this.xmlCatalog.bindToContext(this.dataBindingContext);
        this.updateArguments();
    }

    @Override
    public void updateArguments() {
        List files;
        this.dataBindingContext.updateModels();
        if (this.bindingFiles != null && (files = this.arguments.getBindings()).size() != this.bindingFiles.getFiles().size()) {
            this.bindingFiles.removeAllFiles();
            int i = 0;
            while (i < files.size()) {
                this.bindingFiles.addFiles((IFile)files.get(i));
                ++i;
            }
        }
    }

    protected void handleBrowse(Text text, String title, String message) {
        Object result;
        IProject project = this.arguments.getProject();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(text.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider){

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                StringBuilder msg = new StringBuilder(Messages.jaxb_xjc_option_catalog_browse_dialog_filter_txt);
                Iterator iter = JaxbXJCOptionsPage.this.acceptableExtensions.iterator();
                while (iter.hasNext()) {
                    msg.append((String)iter.next());
                    if (!iter.hasNext()) continue;
                    msg.append(", ");
                }
                new Label(composite, 0).setText(msg.toString());
                return composite;
            }
        };
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IResource) {
                    IFile f;
                    String ext;
                    IResource r = (IResource)element;
                    if (r.isDerived() || r.getName().startsWith(".")) {
                        return false;
                    }
                    return !(r instanceof IFile) || (ext = (f = (IFile)element).getFileExtension()) != null && JaxbXJCOptionsPage.this.acceptableExtensions.contains(ext);
                }
                return false;
            }
        });
        IProject initElement = project;
        dialog.setInput(initElement != null ? initElement : ResourcesPlugin.getWorkspace());
        dialog.setInitialSelection((Object)initElement);
        dialog.setTitle(title);
        dialog.setMessage(message);
        int resultCode = dialog.open();
        if (resultCode != 0) {
            return;
        }
        if (dialog.getReturnCode() == 0 && (result = dialog.getFirstResult()) != null && result instanceof IResource) {
            text.setText(((IResource)result).getProjectRelativePath().toPortableString());
        }
    }

    public final void performHelp() {
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContextId);
        }
    }
}

