/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.common.ContentTypeValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.FileExtensionValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;

public class XmlBindingsValidator
extends FileExtensionValidator {
    private final ContentTypeValidator bindings;

    public XmlBindingsValidator(String ... contentTypeIDs) {
        super("xbd", "xjb");
        this.bindings = new ContentTypeValidator(contentTypeIDs);
    }

    @Override
    public IStatus validate(IFile file) {
        IStatus validate = this.bindings.validate(file);
        if (validate.isOK()) {
            return validate;
        }
        validate = super.validate(file);
        if (validate.isOK()) {
            return validate;
        }
        return this.error(Messages.xml_bindings_validator_error);
    }

    @Override
    public List<String> getExtensions() {
        HashSet<String> extensions = new HashSet<String>();
        extensions.addAll(this.bindings.getFileExtensions());
        extensions.addAll(super.getExtensions());
        return Collections.unmodifiableList(new ArrayList(extensions));
    }
}

