/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.ui.wizards.common.WsdlTableRow;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.ide.IDE;

public final class WsdlTableContentProvider
implements IStructuredContentProvider {
    private ArrayList<WsdlTableRow> list = new ArrayList();
    private static final String WSDL_CONTENT_TYPE_ID = "org.eclipse.wst.wsdl.wsdlsource";

    public WsdlTableContentProvider(IProject project) {
        if (project != null) {
            this.updateBasedOnContainer((IContainer)project);
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.list.toArray(new WsdlTableRow[this.list.size()]);
    }

    public ArrayList<WsdlTableRow> getRows() {
        return this.list;
    }

    public final int getRowCount() {
        return this.list.size();
    }

    private final IResource[] getChildren(IContainer container) {
        ArrayList<IResource> wsdls = new ArrayList<IResource>();
        this.getChildrenFromContainer(wsdls, container);
        return wsdls.toArray(new IResource[wsdls.size()]);
    }

    private void updateBasedOnContainer(IContainer container) {
        IResource[] wsdlsInProject = this.getChildren(container);
        int rowCount = wsdlsInProject.length;
        int i = 0;
        while (i < rowCount) {
            WsdlTableRow fileTableRow = new WsdlTableRow(i);
            fileTableRow.setData(wsdlsInProject[i], wsdlsInProject[i].getFullPath().makeRelative().removeLastSegments(1));
            this.list.add(fileTableRow);
            ++i;
        }
    }

    private void getChildrenFromContainer(List<IResource> collection, IContainer container) {
        IResource[] members;
        if (!container.isAccessible()) {
            return;
        }
        try {
            members = container.members();
        }
        catch (CoreException ce) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (CoreException)ce);
            assert (false);
            return;
        }
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource nextResource = iResourceArray[n2];
            if (!nextResource.isDerived() && !nextResource.getName().startsWith(".")) {
                IContentType contentType;
                if (nextResource.getType() == 2) {
                    IFolder nextFolder = (IFolder)nextResource;
                    this.getChildrenFromContainer(collection, (IContainer)nextFolder);
                } else if (nextResource.getType() == 1 && (contentType = IDE.getContentType((IFile)((IFile)nextResource))) != null && WSDL_CONTENT_TYPE_ID.equals(contentType.getId())) {
                    collection.add(nextResource);
                }
            }
            ++n2;
        }
    }
}

