/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFileSelectionChangedListener;
import oracle.eclipse.tools.webservices.ui.wizards.common.WsdlTableContentProvider;
import oracle.eclipse.tools.webservices.ui.wizards.common.WsdlTableLabelProvider;
import oracle.eclipse.tools.webservices.ui.wizards.common.WsdlTableRow;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public final class TableOfWsdFilesLocationGroup {
    private IProject project;
    private Table table;
    private TableViewer tableViewer;
    private Label wsdlTableLabel;
    private ListenerList listeners = new ListenerList();
    private IStructuredSelection currentSelection;
    final ViewerSorter ascendingSorter = new ViewerSorter(){

        public int compare(Viewer viewer, Object row1, Object row2) {
            String file1 = ((WsdlTableRow)row1).getString(WsdlTableRow.WsdlTableColumnType.WSDL.getIndex());
            String file2 = ((WsdlTableRow)row2).getString(WsdlTableRow.WsdlTableColumnType.WSDL.getIndex());
            return file1.compareTo(file2);
        }
    };
    final ViewerSorter descendingSorter = new ViewerSorter(){

        public int compare(Viewer viewer, Object row1, Object row2) {
            String file1 = ((WsdlTableRow)row1).getString(WsdlTableRow.WsdlTableColumnType.WSDL.getIndex());
            String file2 = ((WsdlTableRow)row2).getString(WsdlTableRow.WsdlTableColumnType.WSDL.getIndex());
            return file2.compareTo(file1);
        }
    };

    public TableOfWsdFilesLocationGroup(IProject project) {
        this.project = project;
    }

    public final void createControl(Composite parent) {
        assert (parent.getLayout() instanceof GridLayout);
        this.wsdlTableLabel = new Label(parent, 0);
        this.table = new Table(parent, 68356);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setLayout((Layout)new GridLayout());
        TableLayout layout = new TableLayout();
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setLayout((Layout)layout);
        this.table.setHeaderVisible(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        final TableColumn fileColumn = new TableColumn(this.table, 16384);
        fileColumn.setText(Messages.wsdl_table_location_group_wsdl_column);
        fileColumn.setAlignment(16384);
        fileColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableViewer tableViewer = TableOfWsdFilesLocationGroup.this.tableViewer;
                Table table = tableViewer.getTable();
                if (tableViewer.getSorter() == TableOfWsdFilesLocationGroup.this.ascendingSorter) {
                    tableViewer.setSorter(TableOfWsdFilesLocationGroup.this.descendingSorter);
                    table.setSortColumn(fileColumn);
                    table.setSortDirection(1024);
                } else {
                    tableViewer.setSorter(TableOfWsdFilesLocationGroup.this.ascendingSorter);
                    table.setSortColumn(fileColumn);
                    table.setSortDirection(128);
                }
            }
        });
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        TableColumn locationColumn = new TableColumn(this.table, 16384);
        locationColumn.setText(Messages.wsdl_table_location_group_location_column);
        locationColumn.setAlignment(16384);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new WsdlTableLabelProvider());
        this.tableViewer.setSorter(this.ascendingSorter);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selElement = selection.getFirstElement();
                IFile selectFile = null;
                if (selElement instanceof WsdlTableRow) {
                    TableOfWsdFilesLocationGroup.this.currentSelection = selection;
                    selectFile = TableOfWsdFilesLocationGroup.this.getSelectedFile();
                } else {
                    TableOfWsdFilesLocationGroup.this.currentSelection = null;
                }
                TableOfWsdFilesLocationGroup.this.fireSelectionChanged(TableOfWsdFilesLocationGroup.this.currentSelection, selectFile);
            }
        });
        this.contentChanged(this.project);
    }

    public void contentChanged(IProject project) {
        if (this.tableViewer != null && project != null && !this.table.isDisposed()) {
            this.wsdlTableLabel.setText(Messages.bind((String)Messages.wsdl_table_location_group_table_label, (Object)project.getName()));
            WsdlTableContentProvider wsdlTableContentProvider = new WsdlTableContentProvider(project);
            this.tableViewer.setContentProvider((IContentProvider)wsdlTableContentProvider);
            this.tableViewer.setInput((Object)project);
            this.currentSelection = null;
            if (wsdlTableContentProvider.getRowCount() == 1) {
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)wsdlTableContentProvider.getRows().get(0)), true);
            }
        }
    }

    public void resetSelection() {
        if (this.currentSelection != null) {
            this.tableViewer.setSelection((ISelection)this.currentSelection, true);
        }
    }

    public IFile getSelectedFile() {
        IFile file = null;
        if (this.currentSelection != null) {
            file = (IFile)((WsdlTableRow)this.currentSelection.getFirstElement()).getData(WsdlTableRow.WsdlTableColumnType.WSDL);
        }
        return file;
    }

    public final void addWsdlSelectionChangedListener(IFileSelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public final void removeWsdlSelectionChangedListener(IFileSelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void fireSelectionChanged(IStructuredSelection selection, IFile wsdl) {
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            ((IFileSelectionChangedListener)l[i]).fileSelectionChanged(selection, wsdl);
            ++i;
        }
    }
}

