/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import java.io.File;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class RelativePathStringToPackageFragmentRootConverter
implements IConverter {
    private final CommonWebServiceAntTaskArguments arguments;

    public RelativePathStringToPackageFragmentRootConverter(CommonWebServiceAntTaskArguments args) {
        this.arguments = args;
    }

    public Object convert(Object fromObject) {
        assert (fromObject instanceof String);
        String s = (String)fromObject;
        IProject project = this.arguments.getProject();
        if (project == null) {
            return null;
        }
        IJavaProject jproj = JavaCore.create((IProject)project);
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = jproj.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getElementName().equals(s)) {
                    return root;
                }
                File relativePackageFragmentRoot = root.getResource().getProjectRelativePath().toFile();
                File sFile = new File(s);
                if (relativePackageFragmentRoot.getPath().equals(sFile.getPath())) {
                    return root;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
        }
        return null;
    }

    public Object getFromType() {
        return String.class;
    }

    public Object getToType() {
        return IPackageFragmentRoot.class;
    }
}

