/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class LabeledTextSelector
implements IValueChangeListener {
    protected final String labelText;
    private String toolTip;
    private final String dialogTitle;
    private final String dialogMessage;
    private DataBindingContext context;
    private final CommonWebServiceAntTaskArguments arguments;
    private final String modelKey;
    private final IContentAssistProcessor processor;
    private Text text;
    private ISWTObservableValue textObservable;
    private Button browse;
    private Label label;
    private Binding binding;
    private final List<ITextChangeListener> listeners = new ArrayList<ITextChangeListener>();

    protected LabeledTextSelector(String label, String dialogTitle, String dialogMsg, CommonWebServiceAntTaskArguments model, String modelKey) {
        this(label, dialogTitle, dialogMsg, model, modelKey, null);
    }

    protected LabeledTextSelector(String label, String toolTip, String dialogTitle, String dialogMsg, CommonWebServiceAntTaskArguments model, String modelKey) {
        this(label, dialogTitle, dialogMsg, model, modelKey, null);
        this.toolTip = toolTip;
    }

    protected LabeledTextSelector(String label, String dialogTitle, String dialogMsg, CommonWebServiceAntTaskArguments model, String modelKey, IContentAssistProcessor processor) {
        this.labelText = label;
        this.dialogTitle = dialogTitle;
        this.dialogMessage = dialogMsg;
        this.arguments = model;
        this.modelKey = modelKey;
        this.processor = processor;
    }

    public final void createControl(Composite parent) {
        assert (parent.getLayout() instanceof GridLayout);
        assert (((GridLayout)parent.getLayout()).numColumns == 3);
        this.label = new Label(parent, 0);
        this.label.setText(this.labelText);
        this.text = new Text(parent, 2052);
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 4;
        this.text.setLayoutData((Object)gd);
        if (this.toolTip != null) {
            this.text.setToolTipText(this.toolTip);
        }
        this.browse = new Button(parent, 8);
        this.browse.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        this.browse.setToolTipText(Messages.wizards_common_browse_tooltip);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabeledTextSelector.this.handleBrowse(LabeledTextSelector.this.text, LabeledTextSelector.this.dialogTitle, LabeledTextSelector.this.dialogMessage);
            }
        });
    }

    public final void bindToContext(DataBindingContext contextParam) {
        if (this.context == null) {
            this.context = contextParam;
            this.text.setText(this.determineDefault());
            this.textObservable = SWTObservables.observeText((Control)this.text, (int)24);
            this.binding = this.context.bindValue((IObservableValue)this.textObservable, BeansObservables.observeValue((Object)this.arguments, (String)this.modelKey), this.createTargetToModelStrategy(), this.createModelToTargetStrategy());
            this.textObservable.addValueChangeListener((IValueChangeListener)this);
            this.resetDefaults();
        }
    }

    protected IProject getProject() {
        return this.arguments.getProject();
    }

    protected CommonWebServiceAntTaskArguments getModel() {
        return this.arguments;
    }

    protected abstract void handleBrowse(Text var1, String var2, String var3);

    protected abstract UpdateValueStrategy createTargetToModelStrategy();

    protected abstract UpdateValueStrategy createModelToTargetStrategy();

    protected abstract String determineDefault();

    public final void resetDefaults() {
        if (this.textObservable != null) {
            this.textObservable.setValue((Object)this.determineDefault());
        }
        if (this.context != null) {
            this.context.updateModels();
        }
    }

    public void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.text.setEnabled(enabled);
        this.browse.setEnabled(enabled);
        if (enabled) {
            this.context.addBinding(this.binding);
        } else {
            this.context.removeBinding(this.binding);
        }
        this.context.updateModels();
    }

    public void addModifyListener(ITextChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeModifyListener(ITextChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void handleValueChange(ValueChangeEvent event) {
        String text = (String)event.getObservableValue().getValue();
        for (ITextChangeListener listener : this.listeners) {
            listener.textChanged(text);
        }
    }

    public static interface ITextChangeListener {
        public void textChanged(String var1);
    }
}

