/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.common.CombinationValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFieldValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledTextSelector;
import oracle.eclipse.tools.webservices.ui.wizards.common.NeverUpdateStrategy;
import oracle.eclipse.tools.webservices.ui.wizards.common.RelativePathStringToPackageFragmentRootConverter;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public final class LabeledSrcRootSelector
extends LabeledTextSelector {
    private IPackageFragmentRoot currentRoot;

    public LabeledSrcRootSelector(String label, String dialogTitle, String dialogMsg, CommonWebServiceAntTaskArguments model, String modelKey) {
        super(label, dialogTitle, dialogMsg, model, modelKey);
    }

    @Override
    protected void handleBrowse(Text text, String title, String message) {
        IProject project = this.getProject();
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                        return root.getKind() == 1 && !root.getResource().isDerived() && !root.getElementName().startsWith(".");
                    }
                    catch (JavaModelException e) {
                        LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(text.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IProject)project));
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                this.currentRoot = jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            } else if (element instanceof IPackageFragmentRoot) {
                this.currentRoot = (IPackageFragmentRoot)element;
            }
            if (this.currentRoot != null) {
                text.setText(this.currentRoot.getResource().getProjectRelativePath().toPortableString());
            }
        }
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        if (this.currentRoot == null) {
            this.currentRoot = this.defaultRoot();
        }
        return this.currentRoot;
    }

    private IPackageFragmentRoot defaultRoot() {
        IJavaProject jproj = JavaCore.create((IProject)this.getProject());
        if (jproj == null) {
            return null;
        }
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = jproj.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource rsrc;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (!(root.isExternal() || !root.isConsistent() || (rsrc = root.getResource()).isDerived() || rsrc.isLinked() || rsrc.getResourceAttributes().isReadOnly())) {
                    return root;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
        }
        return null;
    }

    @Override
    protected String determineDefault() {
        IPackageFragmentRoot root = this.defaultRoot();
        return root != null ? root.getResource().getProjectRelativePath().toPortableString() : "";
    }

    @Override
    protected UpdateValueStrategy createModelToTargetStrategy() {
        return NeverUpdateStrategy.instance;
    }

    @Override
    protected UpdateValueStrategy createTargetToModelStrategy() {
        return new UpdateValueStrategy().setConverter((IConverter)new RelativePathStringToPackageFragmentRootConverter(this.getModel())).setAfterConvertValidator((IValidator)new CombinationValidator(this.labelText, IFieldValidator.srcDirectory));
    }
}

