/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.common.CombinationValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFieldValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledSrcRootSelector;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledTextSelector;
import oracle.eclipse.tools.webservices.ui.wizards.common.NeverUpdateStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public final class LabeledPackageSelector
extends LabeledTextSelector {
    private final LabeledSrcRootSelector srcRoot;
    private String defaultPackage;

    public LabeledPackageSelector(String label, String dialogTitle, String dialogMsg, CommonWebServiceAntTaskArguments model, String modelKey) {
        this(label, "", dialogTitle, dialogMsg, model, modelKey, null, "");
    }

    public LabeledPackageSelector(String label, String dialogTitle, String toolTip, String dialogMsg, CommonWebServiceAntTaskArguments model, String modelKey) {
        this(label, toolTip, dialogTitle, dialogMsg, model, modelKey, null, "");
    }

    public LabeledPackageSelector(String label, String dialogTitle, String dialogMsg, CommonWebServiceAntTaskArguments model, String modelKey, LabeledSrcRootSelector srcRoot) {
        this(label, "", dialogTitle, dialogMsg, model, modelKey, srcRoot, "");
    }

    public LabeledPackageSelector(String label, String toolTip, String dialogTitle, String dialogMsg, CommonWebServiceAntTaskArguments model, String modelKey, LabeledSrcRootSelector srcRoot, String defaultPackage) {
        super(label, toolTip, dialogTitle, dialogMsg, model, modelKey);
        this.srcRoot = srcRoot != null ? srcRoot : new LabeledSrcRootSelector("", "", "", model, "");
        this.defaultPackage = defaultPackage;
    }

    @Override
    protected void handleBrowse(Text text, String title, String message) {
        IPackageFragmentRoot froot = this.srcRoot.getPackageFragmentRoot();
        Object[] packages = null;
        try {
            if (froot != null && froot.exists()) {
                packages = froot.getChildren();
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(text.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_description);
        dialog.setEmptyListMessage(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_empty);
        dialog.setElements(packages);
        dialog.setHelpAvailable(false);
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            dialog.setInitialSelections(new Object[]{pack});
        }
        if (dialog.open() == 0) {
            text.setText(((IPackageFragment)dialog.getFirstResult()).getElementName());
        }
    }

    private IPackageFragment getPackageFragment() {
        return null;
    }

    public void setDefaultPackage(String pkg) {
        this.defaultPackage = !IFieldValidator.packageName.validate(this.labelText, pkg).isOK() ? "" : pkg;
        this.resetDefaults();
    }

    @Override
    protected String determineDefault() {
        return this.defaultPackage;
    }

    @Override
    protected UpdateValueStrategy createModelToTargetStrategy() {
        return NeverUpdateStrategy.instance;
    }

    @Override
    protected UpdateValueStrategy createTargetToModelStrategy() {
        return new UpdateValueStrategy().setAfterConvertValidator((IValidator)new CombinationValidator(this.labelText, IFieldValidator.packageName));
    }
}

