/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.ui.wizards.common.CombinationValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.DestinationDialog;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFieldValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledTextSelector;
import oracle.eclipse.tools.webservices.ui.wizards.common.NeverUpdateStrategy;
import oracle.eclipse.tools.webservices.ui.wizards.common.RelativePathStringToIContainerConverter;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Text;

public final class LabeledIContainerSelector
extends LabeledTextSelector {
    private IPath defaultPath;
    private final IFieldValidator[] validators;

    public LabeledIContainerSelector(String label, String dialogTitle, String dialogMsg, CommonWebServiceAntTaskArguments model, String modelKey) {
        this(label, dialogTitle, dialogMsg, model, modelKey, null, IFieldValidator.directory);
    }

    public LabeledIContainerSelector(String label, String dialogTitle, String dialogMsg, CommonWebServiceAntTaskArguments model, String modelKey, IPath projectRelativeDefault, IFieldValidator ... validator) {
        super(label, dialogTitle, dialogMsg, model, modelKey);
        this.defaultPath = projectRelativeDefault;
        this.validators = validator == null ? new IFieldValidator[]{} : validator;
    }

    @Override
    protected void handleBrowse(Text text, String title, String message) {
        IProject project = this.getProject();
        DestinationDialog dialog = new DestinationDialog(text.getShell(), project, title, message, 2, true, false);
        String currentDest = text.getText().trim();
        if (currentDest.length() > 0) {
            dialog.setOriginalFile((IResource)project.getFolder(currentDest));
        }
        if (dialog.open() == 0) {
            IPath result = dialog.getResult();
            text.setText(result.removeFirstSegments(1).toPortableString());
        }
    }

    @Override
    protected String determineDefault() {
        return this.defaultPath != null ? this.defaultPath.toPortableString() : "";
    }

    @Override
    protected UpdateValueStrategy createModelToTargetStrategy() {
        return NeverUpdateStrategy.instance;
    }

    @Override
    protected UpdateValueStrategy createTargetToModelStrategy() {
        return new UpdateValueStrategy().setConverter((IConverter)new RelativePathStringToIContainerConverter(this.getModel())).setAfterConvertValidator((IValidator)new CombinationValidator(this.labelText, this.validators));
    }

    public void setDefaultPath(IPath projectRelativeDefault) {
        this.defaultPath = projectRelativeDefault;
        this.resetDefaults();
    }

    public void setDefault(IContainer container) {
        this.setDefaultPath(container.getProjectRelativePath());
    }
}

