/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.common.FileExtensionValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFieldValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public final class FileSelectionTree
extends ElementTreeSelectionDialog {
    private final List<IFieldValidator> validators;

    public FileSelectionTree(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, IFieldValidator ... validatorParam) {
        super(parent, labelProvider, contentProvider);
        this.validators = new ArrayList<IFieldValidator>(validatorParam.length);
        Collections.addAll(this.validators, validatorParam);
        this.updateStatus((IStatus)new Status(4, "oracle.eclipse.tools.webservices.ui", ""));
    }

    protected Control createDialogArea(Composite parent) {
        StringBuilder sb = new StringBuilder();
        for (IFieldValidator v : this.validators) {
            if (!(v instanceof FileExtensionValidator)) continue;
            for (String s : ((FileExtensionValidator)v).getExtensions()) {
                sb.append(s).append(", ");
            }
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        new Label(composite, 0).setText(Messages.bind((String)Messages.list_of_files_location_group_filter, (Object)sb));
        return composite;
    }

    public void create() {
        super.create();
        this.getOkButton().setEnabled(false);
    }
}

