/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.common.FileValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FileExtensionValidator
extends FileValidator {
    private final String[] extensions;

    public FileExtensionValidator(String ... extensionsParam) {
        if (extensionsParam == null) {
            this.extensions = new String[0];
        } else {
            this.extensions = new String[extensionsParam.length];
            System.arraycopy(extensionsParam, 0, this.extensions, 0, extensionsParam.length);
        }
    }

    @Override
    public IStatus validate(IFile file) {
        String extension = file.getFullPath().getFileExtension();
        String[] stringArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (ext.equals(extension)) {
                return Status.OK_STATUS;
            }
            ++n2;
        }
        return this.error(Messages.bind((String)Messages.file_extension_validator_only_these_extensions, (Object)file.getName(), Arrays.asList(this.extensions)));
    }

    public List<String> getExtensions() {
        return Collections.unmodifiableList(Arrays.asList(this.extensions));
    }
}

