/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import oracle.eclipse.tools.common.ui.wizards.ContainerContentProvider;
import oracle.eclipse.tools.common.ui.wizards.ResourceAndContainerGroup;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class DestinationDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_SECTION = "DestinationDialogSettings";
    private IResource originalFile = null;
    private IPath result;
    private ResourceAndContainerGroup resourceGroup;
    private Button okButton;
    private final String title;
    private final String message;
    private final IProject project;
    private final int resourceType;
    private final boolean allowExisting;
    private final boolean allowParentEarProjects;

    public DestinationDialog(Shell parentShell, IProject project, String title, String message, int resourceType, boolean allowExisting, boolean allowParentEarProjects) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
        this.message = message;
        this.project = project;
        this.resourceType = resourceType;
        this.allowExisting = allowExisting;
        this.allowParentEarProjects = allowParentEarProjects;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeControls();
        this.validatePage();
        this.resourceGroup.setFocus();
        this.setTitle(this.title);
        this.setMessage(this.message);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                DestinationDialog.this.setDialogComplete(DestinationDialog.this.validatePage());
            }
        };
        this.resourceGroup = new ResourceAndContainerGroupExtension(composite, listener);
        return parentComposite;
    }

    public IPath getResult() {
        return this.result;
    }

    private void initializeControls() {
        if (this.originalFile != null) {
            if (this.originalFile.getType() == 2 && this.originalFile.exists()) {
                this.resourceGroup.setContainerFullPath(this.originalFile.getFullPath());
            } else {
                this.resourceGroup.setContainerFullPath(this.originalFile.getParent().getFullPath());
                this.resourceGroup.setResource(this.originalFile.getName());
            }
        }
        this.setDialogComplete(this.validatePage());
    }

    protected void okPressed() {
        String rsrcPath = this.resourceGroup.getResource();
        IPath path = this.resourceGroup.getContainerFullPath();
        if (!"".equals(rsrcPath)) {
            path = path.append(rsrcPath);
        }
        if (path.getFileExtension() == null && this.originalFile != null && this.originalFile.getFileExtension() != null) {
            path = path.addFileExtension(this.originalFile.getFileExtension());
        }
        this.result = path;
        this.close();
    }

    protected void setDialogComplete(boolean value) {
        this.okButton.setEnabled(value);
    }

    public void setOriginalFile(IResource originalFile) {
        this.originalFile = originalFile;
    }

    private boolean validatePage() {
        IStatus result;
        IProject project;
        String projectName;
        IStatus isValidProjectName;
        String resourceName = this.resourceGroup.getResource();
        if (!this.resourceGroup.areAllValuesValid()) {
            if (!"".equals(resourceName)) {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            } else {
                this.setErrorMessage(null);
            }
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath fullPath = this.resourceGroup.getContainerFullPath();
        if (fullPath != null && (isValidProjectName = workspace.validateName(projectName = fullPath.segment(0), 4)).isOK() && !(project = workspace.getRoot().getProject(projectName)).isOpen()) {
            this.setErrorMessage(Messages.destination_dialog_project_closed);
            return false;
        }
        if (!(this.allowExisting && this.resourceType == 2 && "".equals(resourceName) || (result = workspace.validateName(resourceName, this.resourceType)).isOK())) {
            this.setErrorMessage(result.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = WebServicesUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    private class ContentProviderImpl
    extends ContainerContentProvider {
        private ContentProviderImpl() {
        }

        protected boolean isValidProject(IProject projectParam) {
            if (DestinationDialog.this.project == null || DestinationDialog.this.project == projectParam) {
                return true;
            }
            if (DestinationDialog.this.allowParentEarProjects) {
                for (IProject ear : WtpProjectUtil.findReferencingEarProjects((IProject)DestinationDialog.this.project)) {
                    if (ear != projectParam) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean isValidContainer(IContainer container) {
            return !container.isLinked();
        }
    }

    private class ResourceAndContainerGroupExtension
    extends ResourceAndContainerGroup {
        public ResourceAndContainerGroupExtension(Composite parent, Listener client) {
            super(parent, client, DestinationDialog.this.resourceType == 1 ? Messages.destination_dialog_file_label : Messages.destination_dialog_dir_name, DestinationDialog.this.resourceType == 1 ? Messages.destination_dialog_file : Messages.destination_dialog_folder, (ITreeContentProvider)new ContentProviderImpl());
            this.setAllowExistingResources(DestinationDialog.this.allowExisting);
        }

        protected boolean validateResourceName() {
            String text = this.getResource();
            return DestinationDialog.this.allowExisting && DestinationDialog.this.resourceType == 2 && "".equals(text) ? true : super.validateResourceName();
        }
    }
}

