/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import java.lang.reflect.InvocationTargetException;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ant.IGeneratedFilesValidator;
import oracle.eclipse.tools.webservices.ant.WlsAntScript;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.GeneratedFilesValidator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;

public class AntScriptBackedWizardFinisher {
    private final IWizardContainer container;
    private final WlsAntScript antScript;
    private final String taskName;

    public AntScriptBackedWizardFinisher(IWizardContainer containerParam, WlsAntScript antScriptParam, String taskNameParam) {
        this.container = containerParam;
        this.antScript = antScriptParam;
        this.taskName = taskNameParam;
    }

    public boolean performFinish() {
        try {
            GeneratedFilesValidator validator = new GeneratedFilesValidator(this.container.getShell());
            this.antScript.setValidator((IGeneratedFilesValidator)validator);
            this.container.run(true, false, (IRunnableWithProgress)this.antScript);
            return !validator.wasCancelled();
        }
        catch (InvocationTargetException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices.ui", (Throwable)e, (String)(String.valueOf(this.taskName) + " invocation failed."));
            Throwable target = e.getCause();
            DialogService.showErrorDialog((String)Messages.bind((String)Messages.ant_script_backed_wizard_finisher_script_failure, (Object)this.taskName), (Throwable)target);
            return false;
        }
        catch (InterruptedException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices.ui", (Throwable)e, (String)"Impossible condition, non cancellable action cancelled.");
            return false;
        }
    }
}

