/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.ClientProxyModelResource;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IClientProxyModel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleValuesService;

public class ProjectIMemberPossibleValues
extends PossibleValuesService {
    private static final String SERVICE = "javax.xml.ws.Service";
    private static final int ALL_SEARCH_SCOPE = 15;

    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return Status.Severity.ERROR;
    }

    protected void fillPossibleValues(Set<String> values) {
        IClientProxyModel model = (IClientProxyModel)this.context(Element.class);
        ClientProxyModelResource resource = (ClientProxyModelResource)model.resource();
        IJavaProject jProject = JavaCore.create((IProject)((IProject)model.adapt(IProject.class)));
        HashMap<String, IMember> map = new HashMap<String, IMember>();
        if (jProject != null) {
            List<IMember> members = this.javaSearchScope(SERVICE, 15, 0, 1, 10, jProject);
            for (IMember member : members) {
                map.put(member.getElementName(), member);
                values.add(member.getElementName());
            }
            resource.setPortMemberMap(map);
        }
    }

    private List<IMember> javaSearchScope(String type, int searchScope, int searchFor, int limitTo, int matchRule, IJavaProject jProject) {
        final ArrayList<IMember> typesOfReferences = new ArrayList<IMember>();
        if (type == null) {
            return typesOfReferences;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{jProject}, (int)searchScope);
        SearchPattern pattern = SearchPattern.createPattern((String)type, (int)searchFor, (int)limitTo, (int)matchRule);
        SearchEngine engine = new SearchEngine();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (!(element instanceof IMember)) {
                    return;
                }
                typesOfReferences.add((IMember)element);
            }
        };
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
        }
        return typesOfReferences;
    }
}

