/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.ClientProxyModelResource;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IClientProxyModel;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.services.PossibleValuesService;

public class JavaMethodsValueProvider
extends PossibleValuesService {
    protected void init() {
        super.init();
        ((IClientProxyModel)this.context(IClientProxyModel.class)).getClientClass().attach((Listener)new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                JavaMethodsValueProvider.this.broadcast();
            }
        });
    }

    protected void fillPossibleValues(Set<String> values) {
        Element model = (Element)this.context(Element.class);
        IClientProxyModel clientProxyModel = (IClientProxyModel)model.nearest(IClientProxyModel.class);
        if (clientProxyModel != null) {
            JavaType type = (JavaType)clientProxyModel.getClientClass().resolve();
            if (type == null) {
                return;
            }
            ClientProxyModelResource resource = (ClientProxyModelResource)clientProxyModel.resource();
            HashMap<String, IMethod> methodMap = new HashMap<String, IMethod>();
            try {
                List<IMethod> methods = JavaMethodsValueProvider.getAllITypeMethods((IType)type.artifact());
                for (IMethod method : methods) {
                    String key = this.methodSignature(method);
                    methodMap.put(key, method);
                    values.add(key);
                }
            }
            catch (JavaModelException javaModelException) {}
            resource.setMethodMap(methodMap);
        }
    }

    public static List<IMethod> getAllITypeMethods(IType type) throws JavaModelException {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (!method.isConstructor()) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    public String methodSignature(IMethod method) throws JavaModelException {
        return Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)false, (boolean)false);
    }
}

