/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.services;

import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.ClientProxyModelResource;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IClientProxyModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.services.InitialValueService;
import org.eclipse.sapphire.services.InitialValueServiceData;

public class InitialClassNameProvider
extends InitialValueService {
    protected InitialValueServiceData compute() {
        IClientProxyModel model = (IClientProxyModel)this.context(Element.class);
        return new InitialValueServiceData(InitialClassNameProvider.getClassName(model));
    }

    public static String getClassName(IClientProxyModel model) {
        ClientProxyModelResource resource = (ClientProxyModelResource)model.resource();
        IFile file = (IFile)model.adapt(IFile.class);
        String defaultValue = "";
        if (file != null && file.exists()) {
            ICompilationUnit unit = InitialClassNameProvider.getIcu(file);
            if (unit != null) {
                defaultValue = unit.findPrimaryType().getFullyQualifiedName();
                resource.initializeClass(unit, file);
            }
        } else {
            IFolder folder = (IFolder)model.adapt(IFolder.class);
            if (folder != null) {
                IJavaProject jproj = JavaCore.create((IProject)folder.getProject());
                try {
                    IPackageFragment pkgFragment = jproj.findPackageFragment(folder.getFullPath());
                    defaultValue = String.valueOf(pkgFragment.getElementName()) + ".";
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return defaultValue;
    }

    public static ICompilationUnit getIcu(IFile file) {
        IJavaElement elem;
        if (file != null && (elem = JavaCore.create((IFile)file)) instanceof ICompilationUnit) {
            return (ICompilationUnit)elem;
        }
        return null;
    }
}

