/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.clientgen.ClientGenArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.IAntWrapperPage;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFieldValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.InProjectValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledIFileSelector;
import oracle.eclipse.tools.webservices.ui.wizards.common.ListOfFilesLocationGroup;
import oracle.eclipse.tools.webservices.ui.wizards.common.NeverUpdateStrategy;
import oracle.eclipse.tools.webservices.ui.wizards.common.UrlBrowserDialog;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ClientGenOptionsPage
extends WizardPage
implements IAntWrapperPage {
    private static final Pattern illegalRelativeFileNamePattern = Pattern.compile("[:?;,*\"<>|]");
    private static final String PAGE_NAME = ClientGenOptionsPage.class.getSimpleName();
    private String helpContextId;
    private ClientGenArguments arguments;
    private Composite composite;
    private DataBindingContext dataBindingContext;
    private LabeledIFileSelector xmlCatalog;
    private Label wsdlLocationLabel;
    private Text wsdlLocation;
    private Button verify;
    private ISWTObservableValue copyWsdlObservable;
    private ISWTObservableValue remoteWsdlObservable;
    private ISWTObservableValue noWsdlLocationObservable;

    public ClientGenOptionsPage(ClientGenArguments arguments, String helpContextId) {
        super(PAGE_NAME);
        this.helpContextId = helpContextId;
        this.arguments = arguments;
        this.setTitle(Messages.clientgen_options_page_title);
        this.setDescription(Messages.clientgen_options_page_desc);
    }

    public void createControl(Composite parent) {
        this.dataBindingContext = new DataBindingContext();
        this.initializeDialogUnits((Control)parent);
        this.setupVisualElements(parent);
        this.setupDataBindingAndValidation();
    }

    @Override
    public void updateArguments() {
        IProject project = this.arguments.getProject();
        if (this.composite == null || project == null) {
            return;
        }
        this.copyWsdlObservable.setValue((Object)(this.arguments.getWsdlIFile() != null ? 1 : 0));
        this.remoteWsdlObservable.setValue((Object)false);
        this.noWsdlLocationObservable.setValue((Object)(this.arguments.getWsdlIFile() == null ? 1 : 0));
        if (this.arguments.getWsdlIFile() != null) {
            this.setWsdlLocationEnablement(true);
            this.setWsdlLocationLabelAndToolTip(Messages.clientgen_options_page_copy_wsdl_label, Messages.clientgen_options_page_copy_wsdl_tooltip);
        } else {
            this.setWsdlLocationEnablement(false);
            this.setWsdlLocationLabelAndToolTip(Messages.clientgen_options_page_no_wsdl_label, Messages.clientgen_options_page_no_wsdl_tooltip);
        }
        this.dataBindingContext.updateModels();
    }

    private void setWsdlLocationLabelAndToolTip(String label, String tooltip) {
        if (this.wsdlLocationLabel != null) {
            this.wsdlLocationLabel.setText(label);
            this.wsdlLocationLabel.setToolTipText(tooltip);
        }
        if (this.wsdlLocation != null) {
            this.wsdlLocation.setToolTipText(tooltip);
        }
        this.getShell().layout(true, true);
    }

    private void setWsdlLocationEnablement(boolean enable) {
        if (this.wsdlLocation != null) {
            this.wsdlLocation.setEnabled(enable);
            this.wsdlLocation.setEditable(enable);
        }
        if (this.wsdlLocationLabel != null) {
            this.wsdlLocationLabel.setEnabled(enable);
        }
    }

    private void setupVisualElements(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setFont(parent.getFont());
        this.composite.setLayout((Layout)new GridLayout(3, false));
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Group wsdlLocationGroup = new Group(this.composite, 32);
        wsdlLocationGroup.setText(Messages.clientgen_options_page_wsdl_location_title);
        wsdlLocationGroup.setLayout((Layout)new GridLayout(3, false));
        wsdlLocationGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Composite radioGroup = new Composite((Composite)wsdlLocationGroup, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        radioGroup.setLayout((Layout)gl);
        radioGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.copyWsdlObservable = this.createButtonObservable(Messages.clientgen_options_page_copy_wsdl, "copyWsdl", radioGroup, 16);
        Button b = (Button)this.copyWsdlObservable.getWidget();
        b.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        b.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ClientGenOptionsPage.this.setWsdlLocationEnablement(true);
                ClientGenOptionsPage.this.wsdlLocation.setText("");
                ClientGenOptionsPage.this.setWsdlLocationLabelAndToolTip(Messages.clientgen_options_page_copy_wsdl_label, Messages.clientgen_options_page_copy_wsdl_tooltip);
                ClientGenOptionsPage.this.verify.setEnabled(false);
            }
        });
        this.remoteWsdlObservable = this.createButtonObservable(Messages.clientgen_options_page_remote_wsdl, "remoteWsdl", radioGroup, 16);
        b = (Button)this.remoteWsdlObservable.getWidget();
        b.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        b.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ClientGenOptionsPage.this.verify.setEnabled(true);
                ClientGenOptionsPage.this.setWsdlLocationEnablement(true);
                ClientGenOptionsPage.this.wsdlLocation.setText("");
                ClientGenOptionsPage.this.setWsdlLocationLabelAndToolTip(Messages.clientgen_options_page_remote_wsdl_label, Messages.clientgen_options_page_remote_wsdl_tooltip);
            }
        });
        this.noWsdlLocationObservable = this.createButtonObservable(Messages.clientgen_options_page_no_wsdl, "noCopyWsdl", radioGroup, 16);
        b = (Button)this.noWsdlLocationObservable.getWidget();
        b.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        b.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ClientGenOptionsPage.this.setWsdlLocationEnablement(false);
                ClientGenOptionsPage.this.wsdlLocation.setText("");
                ClientGenOptionsPage.this.setWsdlLocationLabelAndToolTip(Messages.clientgen_options_page_no_wsdl_label, Messages.clientgen_options_page_no_wsdl_tooltip);
                ClientGenOptionsPage.this.verify.setEnabled(false);
            }
        });
        this.wsdlLocationLabel = new Label((Composite)wsdlLocationGroup, 0);
        this.wsdlLocation = new Text((Composite)wsdlLocationGroup, 2052);
        this.wsdlLocation.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.verify = new Button((Composite)wsdlLocationGroup, 8);
        this.verify.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        this.verify.setToolTipText(Messages.wizards_common_browse_tooltip);
        this.verify.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                UrlBrowserDialog dialog = new UrlBrowserDialog(ClientGenOptionsPage.this.getShell(), "WSDL Browser", "Browse for Remote WSDL");
                dialog.setOriginalURL(ClientGenOptionsPage.this.wsdlLocation.getText());
                int resultCode = dialog.open();
                if (resultCode != 0) {
                    return;
                }
                ClientGenOptionsPage.this.wsdlLocation.setText(dialog.getResult());
            }
        });
        this.verify.setEnabled(false);
        Label spacer = new Label(this.composite, 0);
        spacer.setLayoutData((Object)new GridData(4, 0, false, false, 3, 1));
        this.xmlCatalog = new LabeledIFileSelector(Messages.clientgen_options_page_xmlcatalog_label, Messages.clientgen_options_page_xmlcatalog_title, Messages.clientgen_options_page_xmlcatalog_msg, (CommonWebServiceAntTaskArguments)this.arguments, "xmlCatalogFile", null, true, IFieldValidator.optional, IFieldValidator.xmlCatalogFile, new InProjectValidator((CommonWebServiceAntTaskArguments)this.arguments));
        this.xmlCatalog.createControl(this.composite);
        new ListOfFilesLocationGroup((CommonWebServiceAntTaskArguments)this.arguments, "bindings", Messages.clientgen_options_page_select_bindings, Messages.clientgen_options_page_select_bindings_dialog_title, Messages.clientgen_options_page_select_bindings_dialog_msg, IFieldValidator.xmlBindings).createControl(this.composite);
        this.copyWsdlObservable.setValue((Object)true);
        this.remoteWsdlObservable.setValue((Object)false);
        this.noWsdlLocationObservable.setValue((Object)false);
        this.setWsdlLocationEnablement(true);
        this.setWsdlLocationLabelAndToolTip(Messages.clientgen_options_page_copy_wsdl_label, Messages.clientgen_options_page_copy_wsdl_tooltip);
        this.setControl((Control)this.composite);
        Dialog.applyDialogFont((Control)this.composite);
        this.getShell().addControlListener(new ControlListener(){
            private boolean done = false;

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (!this.done) {
                    this.done = true;
                    ClientGenOptionsPage.this.getShell().pack(true);
                }
            }
        });
    }

    protected void checkForWsdlLocationWarning() {
        boolean validURL = true;
        if (((Boolean)this.copyWsdlObservable.getValue()).booleanValue()) {
            Matcher matcher = illegalRelativeFileNamePattern.matcher(this.wsdlLocation.getText());
            if (matcher.find()) {
                validURL = false;
                this.setMessage(Messages.clientgen_options_page_illegal_relative_path, 3);
            } else {
                this.setMessage(null);
            }
        } else if (((Boolean)this.noWsdlLocationObservable.getValue()).booleanValue()) {
            this.setMessage(Messages.clientgen_options_page_no_wsdl_warning, 2);
        } else if (((Boolean)this.remoteWsdlObservable.getValue()).booleanValue()) {
            String wsdlloc = this.wsdlLocation.getText();
            if (wsdlloc.trim().length() == 0) {
                this.setMessage(Messages.clientgen_options_page_empty_url_error, 3);
                validURL = false;
            } else {
                try {
                    new URL(wsdlloc);
                    this.setMessage(null);
                }
                catch (MalformedURLException malformedURLException) {
                    validURL = false;
                    this.setMessage(Messages.clientgen_options_page_invalid_url_error, 3);
                }
            }
        }
        this.setPageComplete(validURL);
    }

    protected void handleHandlerChainBrowse() {
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setAllowMultiple(false);
        dialog.setInput((Object)this.arguments.getProject());
        dialog.setTitle(Messages.clientgen_options_page_handler_chain_title);
        dialog.setMessage(Messages.clientgen_options_page_handler_chain_msg);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IResource) {
                    IFile f;
                    String ext;
                    IResource r = (IResource)element;
                    if (r.isDerived() || r.getName().startsWith(".")) {
                        return false;
                    }
                    return !(r instanceof IFile) || (ext = (f = (IFile)element).getFileExtension()) != null && ext.equals("xml");
                }
                return false;
            }
        });
        dialog.open();
    }

    private ISWTObservableValue createButtonObservable(String label, String argumentsBeanFieldToBindTo, Composite parent, int style) {
        Button button = new Button(parent, style);
        button.setText(label);
        ISWTObservableValue observable = SWTObservables.observeSelection((Control)button);
        this.dataBindingContext.bindValue((IObservableValue)observable, BeansObservables.observeValue((Object)this.arguments, (String)argumentsBeanFieldToBindTo), new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_UPDATE), (UpdateValueStrategy)NeverUpdateStrategy.instance);
        return observable;
    }

    private void setupDataBindingAndValidation() {
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dataBindingContext);
        this.dataBindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.wsdlLocation, (int)24), BeansObservables.observeValue((Object)this.arguments, (String)"wsdlLocation"), new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_UPDATE), (UpdateValueStrategy)NeverUpdateStrategy.instance);
        this.wsdlLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClientGenOptionsPage.this.checkForWsdlLocationWarning();
            }
        });
        this.copyWsdlObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent e) {
                ClientGenOptionsPage.this.checkForWsdlLocationWarning();
            }
        });
        this.remoteWsdlObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent e) {
                ClientGenOptionsPage.this.checkForWsdlLocationWarning();
            }
        });
        this.noWsdlLocationObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent e) {
                ClientGenOptionsPage.this.checkForWsdlLocationWarning();
            }
        });
        this.xmlCatalog.bindToContext(this.dataBindingContext);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.dataBindingContext.updateTargets();
        }
        super.setVisible(visible);
    }

    public final void performHelp() {
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContextId);
        }
    }
}

