/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.bindings;

import oracle.eclipse.tools.common.ui.wizards.NewFileWizard;
import oracle.eclipse.tools.common.ui.wizards.NewFileWizardPage;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.bindings.BindingsArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.bindings.BindingsFileLocatorContentProvider;
import oracle.eclipse.tools.webservices.ui.wizards.bindings.NewBindingsFileLocationPage;
import oracle.eclipse.tools.webservices.ui.wizards.bindings.WsdlLocationTablePage;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFileSelectionChangedListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public final class NewBindingsFileWizard
extends NewFileWizard {
    private static final String HELP_CONTEXT_ID = "oracle.eclipse.tools.webservices.ui.NewBindingsFileWizard";
    private final BindingsArguments arguments;
    private NewBindingsFileLocationPage bindingPage = null;
    private WsdlLocationTablePage wsdlPage = null;

    public NewBindingsFileWizard() {
        this(new BindingsArguments());
    }

    public NewBindingsFileWizard(BindingsArguments arguments) {
        this.arguments = arguments;
        this.setDialogSettings(WebServicesUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(Messages.jaxws_custom_bindings_file_wizard_title);
        this.setDefaultPageImageDescriptor(WebServicesUIPlugin.Images.JAXWS_BINDINGS_BANNER.getImageDescriptor());
    }

    public void addPages() {
        super.addPages();
        if (this.getArguments().getWsdlIFile() == null) {
            this.wsdlPage = this.createWsdlLocationPage();
            this.addPage((IWizardPage)this.wsdlPage);
        }
    }

    public NewFileWizardPage createFilePage() {
        BindingsFileLocatorContentProvider bindingLocatorContentProvider = null;
        bindingLocatorContentProvider = this.getArguments().getWsdlIFile() != null ? new BindingsFileLocatorContentProvider(this.getArguments().getWsdlIFile().getProject()) : new BindingsFileLocatorContentProvider();
        this.bindingPage = new NewBindingsFileLocationPage(this.getArguments(), bindingLocatorContentProvider, new FileSelectionChangedListenerImpl(), this.getSelection(), HELP_CONTEXT_ID);
        this.bindingPage.setTitle(Messages.jaxws_custom_bindings_file_wizard_page_title);
        this.bindingPage.setDescription(Messages.jaxws_custom_bindings_file_wizard_page_description);
        return this.bindingPage;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.arguments.getWsdlURI() != null) {
            this.updatePages();
        }
        IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
        help.setHelp((Control)this.getShell(), HELP_CONTEXT_ID);
    }

    private BindingsArguments getArguments() {
        return this.arguments;
    }

    private void updatePages() {
        if (this.wsdlPage != null) {
            this.wsdlPage.updateContent();
        }
    }

    private WsdlLocationTablePage createWsdlLocationPage() {
        return new WsdlLocationTablePage(this.getArguments(), HELP_CONTEXT_ID);
    }

    private class FileSelectionChangedListenerImpl
    implements IFileSelectionChangedListener {
        private FileSelectionChangedListenerImpl() {
        }

        @Override
        public boolean fileSelectionChanged(IStructuredSelection selection, IFile file) {
            if (file == null) {
                return false;
            }
            IProject project = file.getProject();
            assert (WebServiceProject.isWebServiceProject((IProject)project)) : "Not allowing selection for non-webservice project";
            NewBindingsFileWizard.this.arguments.setBindingFile(file);
            NewBindingsFileWizard.this.updatePages();
            return true;
        }
    }
}

