/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.bindings;

import com.bea.wlw.template.ITemplateBean;
import com.bea.wlw.template.exceptions.GenerationFailedException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import oracle.eclipse.tools.common.templating.filetemplate.FormattingService;
import oracle.eclipse.tools.common.templating.template.core.TemplateService;
import oracle.eclipse.tools.common.ui.wizards.NewFileWizardPage;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.common.util.fileio.FolderUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.bindings.BindingsArguments;
import oracle.eclipse.tools.webservices.bindings.BindingsTemplateBean;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.bindings.BindingsFileLocatorContentProvider;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFileSelectionChangedListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;

public final class NewBindingsFileLocationPage
extends NewFileWizardPage {
    public static final String PAGE_NAME = "BindingLocationPage";
    private static final String CUSTOM_BINDING_CONTENT_TYPE_ID = "oracle.eclipse.tools.webservices.jaxWSBindings";
    private final IFileSelectionChangedListener fileSelectionChangedListener;
    private final BindingsFileLocatorContentProvider bindingLocatorContentProvider;
    private String helpContextId;
    private final BindingsArguments arguments;
    private String warningMsg = null;
    private String defaultFileExtension;

    public NewBindingsFileLocationPage(BindingsArguments arguments, BindingsFileLocatorContentProvider bindingLocatorContentProvider, IFileSelectionChangedListener fileSelectionChangedListener, IStructuredSelection selection, String helpContextId) {
        super(PAGE_NAME, selection, helpContextId);
        this.setFileName(this.getDefaultFileName());
        this.defaultFileExtension = this.determineDefaultFileExtension();
        this.bindingLocatorContentProvider = bindingLocatorContentProvider;
        this.fileSelectionChangedListener = fileSelectionChangedListener;
        this.arguments = arguments;
        this.helpContextId = helpContextId;
    }

    protected boolean allowLinking() {
        return false;
    }

    public IFile createNewFile() {
        IFile file = this.arguments.getBindingFile();
        BindingsTemplateBean bean = new BindingsTemplateBean(this.arguments);
        try {
            String fileContents = TemplateService.generate((String)"oracle.eclipse.tools.webservices.filetemplate.binding", (ITemplateBean)bean);
            fileContents = FormattingService.formatSource((IProject)file.getProject(), (IPath)file.getLocation(), (String)fileContents);
            boolean force = true;
            IProgressMonitor progressMonitor = null;
            ByteArrayInputStream stream = new ByteArrayInputStream(fileContents.getBytes(StandardCharsets.UTF_8));
            FolderUtil.ensureFolder((IFile)file, (boolean)false, progressMonitor);
            file.create((InputStream)stream, force, progressMonitor);
            return file;
        }
        catch (GenerationFailedException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
        }
        return null;
    }

    public void handleEvent(Event event) {
        super.handleEvent(event);
        if (this.isPageComplete()) {
            this.fileSelectionChangedListener.fileSelectionChanged(null, this.getFile());
        }
    }

    public void performHelp() {
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContextId);
        }
    }

    protected ITreeContentProvider createContainerContentProvider() {
        return this.bindingLocatorContentProvider;
    }

    protected boolean validatePage() {
        this.warningMsg = null;
        boolean ret = super.validatePage();
        if (ret && this.warningMsg != null) {
            this.setMessage(this.warningMsg, 2);
        }
        return ret;
    }

    protected boolean validateFile(IFile file) {
        if (file.getName().startsWith(".")) {
            this.setErrorMessage(Messages.jaxws_custom_bindings_file_start_with_dot);
            return false;
        }
        if (!this.hasValidExtension(file)) {
            this.setErrorMessage(Messages.bind((String)Messages.jaxws_custom_bindings_file_wizard_page_error_file_name_extension, (Object)this.getDefaultFileExtension()));
            return false;
        }
        if (!EclipseFileUtil.caseSensitiveDoesNotExist((IFile)file)) {
            this.setErrorMessage(Messages.jaxws_custom_bindings_file_wizard_page_error_case_insensitive_type_exists);
            return false;
        }
        return true;
    }

    protected String getDefaultFileExtension() {
        return this.defaultFileExtension;
    }

    private String determineDefaultFileExtension() {
        IContentType contentType = Platform.getContentTypeManager().getContentType(CUSTOM_BINDING_CONTENT_TYPE_ID);
        if (contentType == null) {
            LoggingService.logError((Plugin)WebServicesUIPlugin.getDefault(), (String)"unable to resolve jaxwsbinding content type id");
            return null;
        }
        String[] customBindingExtensions = contentType.getFileSpecs(8);
        return customBindingExtensions[0];
    }
}

