/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.bindings;

import java.util.ArrayList;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.bindings.BindingsFileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public final class BindingsFileLocatorContentProvider
implements ITreeContentProvider {
    private final IProject selectedProject;

    public BindingsFileLocatorContentProvider() {
        this(null);
    }

    public BindingsFileLocatorContentProvider(IProject selectedProject) {
        this.selectedProject = selectedProject;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        return element instanceof IResource ? ((IResource)element).getParent() : null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IWorkspace) {
            return this.getChildrenFromWorkspace((IWorkspace)element);
        }
        if (element instanceof IContainer) {
            return this.getChildrenFromContainer((IContainer)element);
        }
        return new Object[0];
    }

    private boolean isAcceptableProject(IProject project) {
        return BindingsFileUtil.isEnabledOn(project);
    }

    private Object[] getChildrenFromWorkspace(IWorkspace workspace) {
        IProject[] allProjects = workspace.getRoot().getProjects();
        ArrayList<IProject> wsProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject nextProject = iProjectArray[n2];
            if (nextProject.isOpen() && this.isSelectedProject(nextProject) && this.isAcceptableProject(nextProject)) {
                wsProjects.add(nextProject);
            }
            ++n2;
        }
        return wsProjects.toArray();
    }

    private Object[] getChildrenFromContainer(IContainer container) {
        IResource[] members;
        if (!container.isAccessible()) {
            return new Object[0];
        }
        ArrayList<IFolder> children = new ArrayList<IFolder>();
        try {
            members = container.members();
        }
        catch (CoreException ce) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)ce);
            return new Object[0];
        }
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource nextResource = iResourceArray[n2];
            if (!nextResource.isDerived() && !nextResource.getName().startsWith(".") && nextResource.getType() == 2) {
                children.add((IFolder)nextResource);
            }
            ++n2;
        }
        return children.toArray();
    }

    private boolean isSelectedProject(IProject project) {
        if (this.selectedProject == null) {
            return true;
        }
        return this.selectedProject.equals((Object)project);
    }
}

