/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.model.LightweightWsdlModel;
import oracle.eclipse.tools.webservices.model.WsdlParseFaildedException;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public final class WsdlModelFactory
implements IRunnableWithProgress {
    private final URI uri;
    private transient LightweightWsdlModel model;

    private WsdlModelFactory(URI uri) {
        this.uri = uri;
    }

    public static LightweightWsdlModel createModel(IRunnableContext context, URL url) {
        try {
            return WsdlModelFactory.createModel(context, url.toURI());
        }
        catch (URISyntaxException e) {
            DialogService.showErrorDialog((String)Messages.bind((String)Messages.wsdl_model_factory_uri_syntax_error, (Object)url.toString()), (Throwable)e);
            return null;
        }
    }

    public static LightweightWsdlModel createModel(IRunnableContext context, IFile ifile) {
        File file = ifile.getLocation().toFile();
        if (!file.exists()) {
            DialogService.showErrorDialog((String)Messages.bind((String)Messages.wsdl_model_factory_file_does_not_exist, (Object)file.getAbsolutePath()));
        }
        return WsdlModelFactory.createModel(context, file.toURI());
    }

    public static LightweightWsdlModel createModel(IRunnableContext context, URI uri) {
        URI wsdlURI = uri.normalize();
        WsdlModelFactory factory = new WsdlModelFactory(wsdlURI);
        try {
            context.run(true, false, (IRunnableWithProgress)factory);
        }
        catch (InvocationTargetException e) {
            DialogService.showErrorDialog((String)e.getCause().getLocalizedMessage(), (Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e, (String)"cancel on non cancellable dialog");
        }
        return factory.getModel();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.model = new LightweightWsdlModel(this.uri);
        }
        catch (WsdlParseFaildedException e) {
            throw new InvocationTargetException(e);
        }
    }

    private LightweightWsdlModel getModel() {
        return this.model;
    }
}

